/**
 *  GuideAreaExtractionConfig.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/07
 Author hiroya
 */
package net.sqs2.omr.session.config;

import java.io.Serializable;

public class PageGuideAreaConfig implements Serializable {
	private static final long serialVersionUID = 1L;

	float density;
	float height;
	float horizontalMargin;
	float headerVerticalMargin;
	float footerVerticalMargin;
	boolean debug;

	BlockRecognitionFilterConfig blockRecognitionFilterConfig;
	BlockRecognitionConfig blockRecognitionConfig;

	public PageGuideAreaConfig() {
	}

	public float getDensity() {
		return this.density;
	}

	public void setDensity(float density) {
		this.density = density;
	}

	public float getHeight() {
		return this.height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public float getHeaderVerticalMargin() {
		return this.headerVerticalMargin;
	}

	public void setHeaderVerticalMargin(float headerVerticalMargin) {
		this.headerVerticalMargin = headerVerticalMargin;
	}

	public float getFooterVerticalMargin() {
		return this.footerVerticalMargin;
	}

	public void setFooterVerticalMargin(float footerVerticalMargin) {
		this.footerVerticalMargin = footerVerticalMargin;
	}

	public float getHorizontalMargin() {
		return this.horizontalMargin;
	}

	public void setHorizontalMargin(float horizontalMargin) {
		this.horizontalMargin = horizontalMargin;
	}

	public BlockRecognitionFilterConfig getBlockRecongnitionFilterConfig() {
		return this.blockRecognitionFilterConfig;
	}

	public void setBlockRecognitionFilterConfig(BlockRecognitionFilterConfig blockRecognitionConfig) {
		this.blockRecognitionFilterConfig = blockRecognitionConfig;
	}

	public BlockRecognitionConfig getBlockRecognitionConfig() {
		return this.blockRecognitionConfig;
	}

	public void setBlockRecognitionConfig(BlockRecognitionConfig blockRecognitionConfig) {
		this.blockRecognitionConfig = blockRecognitionConfig;
	}

	public boolean isDebug() {
		return this.debug;
	}

	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	public BlockRecognitionFilterConfig getBlockRecognitionFilterConfig() {
		return this.blockRecognitionFilterConfig;
	}

}
