package net.sqs2.omr.session.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

import net.sqs2.xml.XMLFilterUtil;

public class ConfigXMLFileFilter {

	File target;
	String densityThreshold = null;
	String doubleMarkIgnoranceThreshold = null;

	private static final String DENSITY_XPATH = "/config/sources/source/markRecognition/@density";
	private static final String DOUBLE_MARK_IGNORANCE_THRESHOLD_XPATH = "/config/sources/source/markRecognition/@doubleMarkIgnoranceThreshold";

	public ConfigXMLFileFilter(File target) {
		this.target = target;
		try {
			String[] values = XMLFilterUtil.selectValues(this.target, new String[] { DENSITY_XPATH,
					DOUBLE_MARK_IGNORANCE_THRESHOLD_XPATH });
			this.densityThreshold = values[0];
			this.doubleMarkIgnoranceThreshold = values[1];
		} catch (IOException ex) {
			Logger.getAnonymousLogger().info(ex.getLocalizedMessage());
			this.densityThreshold = null;
			this.doubleMarkIgnoranceThreshold = null;
		}
	}

	public void overwriteValues(float densityThreshold, float doubleMarkIgnoranceThreshold) {
		String[][] args = new String[][] { { DENSITY_XPATH, Float.toString(densityThreshold) },
				{ DOUBLE_MARK_IGNORANCE_THRESHOLD_XPATH, Float.toString(doubleMarkIgnoranceThreshold) } };
		this.densityThreshold = args[0][1];
		this.doubleMarkIgnoranceThreshold = args[1][1];
		XMLFilterUtil.overwrite(this.target, args);
	}

	public String getDensityThreshold() {
		return this.densityThreshold;
	}

	public String getDoubleMarkIgnoranceThreshold() {
		return this.doubleMarkIgnoranceThreshold;
	}

	/*
	 * public static void main(String[] args){ ConfigXMLFileFilter self = new
	 * ConfigXMLFileFilter(new File("/tmp/config.xml"));
	 * self.overwriteDensityThreashold(0.99f); }
	 */
}
