package net.sqs2.omr.session.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import net.sqs2.omr.AppConstants;
import net.sqs2.util.FileUtil;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

public class ConfigManager {
	
	protected static final Digester DIGESTER;
	public final static Config DEFAULT_INSTANCE;
	static {
		try {
			String baseURI = "class://"+ConfigManager.class.getCanonicalName()+"/";
			DIGESTER = DigesterLoader.createDigester(new URL(baseURI + "configRule.xml"));
			DEFAULT_INSTANCE = (Config) DIGESTER.parse(new URL(baseURI + AppConstants.SOURCE_CONFIG_FILENAME));
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	public static Config createConfigInstance(URL url) {
		try {
			Config config = (ConfigImpl) DIGESTER.parse(url);
			if (! DEFAULT_INSTANCE.getVersion().equals(config.getVersion())) {
				Logger.getAnonymousLogger().warning(
						"Config file version in Source Directory is old. Override default config.");
				File configFile = new File(url.getFile());
				File backupConfigFile = new File(FileUtil.getBasepath(configFile) + "-"
						+ config.getVersion() + ".old.xml");
				if (!backupConfigFile.exists()) {
					configFile.renameTo(backupConfigFile);
				}
				// TODO: GUI alert on using default config and backup config
				// file.
				ConfigUtil.createConfigFile(configFile);
				config = (ConfigImpl) DIGESTER.parse(url);
			}
			return config;

		} catch (IOException ex) {
			throw new RuntimeException(ex);
		} catch (SAXException ex) {
			throw new RuntimeException(ex);
		}
	}

}
