/*

 ConfigImpl.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on Apr 7, 2007

 */

package net.sqs2.omr.session.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConfigImpl implements Config, Serializable {
	private final static long serialVersionUID = 0L;

	protected List<SourceConfig> sourceList = new ArrayList<SourceConfig>();
	String version;

	public void addSource(SourceConfig sourceConfig) {
		this.sourceList.add(sourceConfig);
	}

	public SourceConfig getSourceConfig() {
		return this.sourceList.get(0);
	}

	public SourceConfig getSourceConfig(int index) {
		return this.sourceList.get(index);
	}

	public SourceConfig getSourceConfig(String path, int pageNumber) {
		for (SourceConfig sourceConfig : this.sourceList) {
			if (sourceConfig.match(path, pageNumber)) {
				return sourceConfig;
			}
		}
		throw new RuntimeException("no matched config file");
	}

	public String getVersion() {
		return this.version;
	}

	public void setVersion(String version) {
		this.version = version;
	}
}
