package net.sqs2.omr.session.broker.impl;

import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.session.broker.AbstractExecutorPeerBroker;
import net.sqs2.omr.session.broker.AbstractRemoteExecutorManager;
import net.sqs2.omr.session.broker.ExecutorPeer;
import net.sqs2.omr.session.source.RemoteSessionSourceServer;

public class RemotePageTaskExecutorManager extends AbstractRemoteExecutorManager<PageTask, PageTaskExecutorSessionServerDispatcher, PageTaskExecutable> {
	
	public RemotePageTaskExecutorManager(ExecutorPeer<PageTask, PageTaskExecutorSessionServerDispatcher> executorPeer, int maximumNumberOfConnections) {
		super(executorPeer, maximumNumberOfConnections);
	}
	
	//<PageTaskExecutor,PageTaskSessionServiceDispacher>
	public AbstractExecutorPeerBroker<PageTask, PageTaskExecutorSessionServerDispatcher, PageTaskExecutable> createExecutorPeerBroker(ExecutorPeer<PageTask,
			PageTaskExecutorSessionServerDispatcher> executorPeer, 
			RemoteSessionSourceServer remoteSessionService, long remoteKey){
		return new PageTaskExecutorPeerBroker("Remote", executorPeer,
				new PageTaskExecutorSessionServerDispatcher(null, remoteSessionService, remoteKey));
	}
}
