/**
 *  TaskExecutorEnv.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/31
 Author hiroya
 */

package net.sqs2.omr.session.broker.impl;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.model.AbstractPageTask;
import net.sqs2.omr.session.broker.SessionServerDispatcher;
import net.sqs2.omr.session.config.SourceDirectoryConfiguration;
import net.sqs2.omr.session.source.RemoteSessionSourceServer;
import net.sqs2.omr.session.source.SessionSourceServer;
import net.sqs2.omr.util.FileResource;
import net.sqs2.util.FileResourceID;

import org.apache.commons.collections15.map.LRUMap;

public class PageTaskExecutorSessionServerDispatcher extends SessionServerDispatcher{

	public static final int IMAGE_BYTEARRAY_CACHE_SIZE = 3; // size
	private Map<FileResourceID, PageMaster> pageMasterCache = new LRUMap<FileResourceID, PageMaster>();
	private Map<FileResourceID, SourceDirectoryConfiguration> configHandlerCache = new HashMap<FileResourceID, SourceDirectoryConfiguration>();
	private Map<FileResourceID, FileResource> fileResourceCache = new LRUMap<FileResourceID, FileResource>(32);

	public PageTaskExecutorSessionServerDispatcher(SessionSourceServer localSessionService, RemoteSessionSourceServer remoteSessionService,
			long key){
		super(localSessionService, remoteSessionService, key);
	}
	
	public byte[] getImageByteArray(long sessionID, FileResourceID fileResourceID) throws RemoteException {
		synchronized (this.fileResourceCache) {
			FileResource fileResource = this.fileResourceCache.get(fileResourceID);
			if (fileResource == null) {
				fileResource = getSessionService().getFileResource(getKey(), sessionID, fileResourceID);
				this.fileResourceCache.put(fileResourceID, fileResource);
			}
			return fileResource.getBytes();
		}
	}

	public PageMaster getPageMaster(long sessionID, AbstractPageTask pageTask) throws RemoteException {
		return getPageMaster(sessionID, pageTask.getMasterFileResourceID());
	}

	public PageMaster getPageMaster(long sessionID, FileResourceID fileResourceID) throws RemoteException {
		synchronized (this.pageMasterCache) {
			PageMaster master = this.pageMasterCache.get(fileResourceID);
			if (master == null) {
				master = getSessionService().getMaster(getKey(), sessionID, fileResourceID);
				this.pageMasterCache.put(fileResourceID, master);
			}
			return master;
		}
	}

	public SourceDirectoryConfiguration getConfiguration(long sessionID, FileResourceID fileResourceID) throws RemoteException {
		synchronized (this.configHandlerCache) {
			SourceDirectoryConfiguration configHandler = this.configHandlerCache.get(fileResourceID);
			if (configHandler == null) {
				configHandler = getSessionService().getConfigration(getKey(), sessionID, fileResourceID);
				this.configHandlerCache.put(fileResourceID, configHandler);
			}
			return configHandler;
		}
	}

}
