package net.sqs2.omr.session.broker.impl;

import java.rmi.RemoteException;

import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.session.broker.TaskExecutor;

public class PageTaskExecutor extends TaskExecutor<PageTask, PageTaskExecutorSessionServerDispatcher, PageTaskExecutable> implements Runnable {
	
	public PageTaskExecutor(PageTaskExecutorPeerBroker executorPeerBroker,
			PageTaskExecutorSessionServerDispatcher sessionServiceDispacher){
		super(executorPeerBroker, sessionServiceDispacher);
	}
	
	protected PageTask leaseTask()throws RemoteException{
		return 
		this.getSessionServiceDispatcher().getSessionService().leaseTask(this.getSessionServiceDispatcher().getKey()); 
		// may cause blocking	
	}
	
	protected PageTaskExecutable createExecutable(PageTask pageTask){	
		return new PageTaskExecutable(pageTask, this.getSessionServiceDispatcher());
	}
	
}