package net.sqs2.omr.session.broker;

import net.sqs2.omr.session.source.RemoteSessionSourceServer;
import net.sqs2.omr.session.source.SessionSourceServer;

public abstract class SessionServerDispatcher {
	
	private SessionSourceServer localSessionService;
	private RemoteSessionSourceServer remoteSessionService;
	private long key;

	private boolean hasInitialized = false;

	public SessionServerDispatcher(SessionSourceServer localSessionService, RemoteSessionSourceServer remoteSessionService,
			long key) {
		this.localSessionService = localSessionService;
		this.remoteSessionService = remoteSessionService;
		this.key = key;
	}

	public void setInitialized() {
		this.hasInitialized = true;
	}

	public boolean hasInitialized() {
		return this.hasInitialized;
	}

	public long getKey() {
		return this.key;
	}

	public boolean isRemote() {
		return (this.remoteSessionService != null);
	}

	public SessionSourceServer getLocalSessionService() {
		return this.localSessionService;
	}

	public SessionSourceServer getSessionService() {
		if (this.localSessionService != null) {
			return this.localSessionService;
		} else if (this.remoteSessionService != null) {
			return this.remoteSessionService;
		} else {
			throw new RuntimeException("localSessionService == null and remoteSessionService == null");
		}
	}

	public void close() {
		if (this.remoteSessionService != null) {
			this.remoteSessionService = null;
		}
		if (this.localSessionService != null) {
			this.localSessionService = null;
		}
	}
}
