/**
 * 
 */
package net.sqs2.omr.session.broker;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import net.sqs2.lang.GroupThreadFactory;
import net.sqs2.omr.model.AbstractTask;

class RemoteExecutorPeerBrokerConnectionManager <T extends AbstractTask, D extends SessionServerDispatcher, E extends AbstractExecutable<T,D>>{
	Map<String, AbstractExecutorPeerBroker<T,D,E>> executorPeerBrokerMap;

	RemoteExecutorPeerBrokerConnectionManager(Map<String, AbstractExecutorPeerBroker<T,D,E>> remoteTaskBrokerMap) {
		this(remoteTaskBrokerMap, 60);
	}

	RemoteExecutorPeerBrokerConnectionManager(Map<String, AbstractExecutorPeerBroker<T,D,E>> remoteTaskBrokerMap, int executionDelayInSec) {
		this.executorPeerBrokerMap = remoteTaskBrokerMap;
		Executors.newSingleThreadScheduledExecutor(
				new GroupThreadFactory("RemoteExecutor", Thread.NORM_PRIORITY, true))
				.scheduleWithFixedDelay(new Runnable() {
					public void run() {
						cleanupConnections();
					}
				}, executionDelayInSec, executionDelayInSec, TimeUnit.SECONDS);
	}

	private void cleanupConnections() {
		for (Map.Entry<String, AbstractExecutorPeerBroker<T,D,E>> e : this.executorPeerBrokerMap.entrySet()) {
			String uri = e.getKey();
			AbstractExecutorPeerBroker<T,D,E> taskBroker = e.getValue();
			if (taskBroker.isConnected() == false) {
				this.executorPeerBrokerMap.remove(uri);
				Logger.getLogger("executor").info("Remove old taskBroker=" + uri);
			}
		}
	}
}
