package net.sqs2.omr.session.broker;

import java.rmi.RemoteException;

import net.sqs2.omr.model.AbstractTask;

public abstract class AbstractExecutable<T extends AbstractTask, D extends SessionServerDispatcher>{

	private T task;
	private D sessionServiceDispatcher;

	public AbstractExecutable(T task, D sessionServiceDispatcher){
		this.task = task;
		this.sessionServiceDispatcher = sessionServiceDispatcher;
	}

	public T getTask() {
		return this.task;
	}

	public D getSessionServiceDispatcher() {
		return this.sessionServiceDispatcher;
	}
	
	public abstract void call() throws RemoteException;
	public abstract void submit() throws RemoteException;

}