package net.sqs2.omr.result.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;

import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.session.source.SessionSource;

public class StatisticsContentsJSONWriter extends StatisticsContentsWriter {
	protected PrintWriter w;

	public StatisticsContentsJSONWriter(PrintWriter w, SessionSource sessionSource, String viewMode)
			throws IOException {
		super(sessionSource, viewMode);
		this.w = w;
	}

	@Override
	public void create(FormMaster master, Set<Integer> selectedTableIndexSet, Set<Integer> selectedRowIndexSet, Set<Integer> selectedQuestionIndexSet) {

		if (selectedTableIndexSet == null || selectedTableIndexSet.isEmpty()) {
			this.w.println("contentsDispatcher.statValues = {};");
			return;
		}

		super.create(master, selectedTableIndexSet, selectedRowIndexSet, selectedQuestionIndexSet);

		this.w.print("contentsDispatcher.statValues={");
		boolean hasPrinted = false;
		for (String key : this.values.uniqueSet()) {
			if (hasPrinted) {
				this.w.print(",");
			} else {
				hasPrinted = true;
			}
			this.w.print("'");
			this.w.print(key);
			this.w.print("':");
			this.w.print(this.values.getCount(key));
		}
		this.w.println("};");
	}

}
