package net.sqs2.omr.result.writer;

import javax.servlet.http.HttpServletRequest;

import net.sqs2.omr.util.HttpUtil;

public class ResultBrowserSessionParamParser extends ResultContentSelectorParamParser {

	public static ResultBrowserSessionParam parse(ResultBrowserSessionParam param, HttpServletRequest req) {
		param = (ResultBrowserSessionParam) ResultContentSelectorParamParser.parse(param, req);
		param.setUpdater(req.getParameter("u"));
		param.setViewMode(req.getParameter("v"));
		param.setMSIE(HttpUtil.isMSIE(req));
		param.setSessionID(parseLong(req.getParameter("sid")));
		param.setCrossTableAxis(req.getParameter("axis"));

		param.setAnswerItemIndex(getIntegerParameter(req, "n"));
		if (param.getAnswerItemIndex() == -1) {
			param.setAnswerItemIndex(0);
		}
		param.setNumMaxAnswerItems(getIntegerParameter(req, "N"));
		if (param.getNumMaxAnswerItems() == -1) {
			param.setNumMaxAnswerItems(NUM_MAX_ANSWER_ITEMS);
		}
		return param;
	}
}
