/*

 ResultBrowserParam.java

 Copyright 2008 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2008/01/13

 */
package net.sqs2.omr.result.writer;


public class ResultBrowserSessionParam extends ResultContentSelectorParam {

	protected String updater = null;
	protected String viewMode;
	protected long sessionID;
	protected String axis;
	protected int answerItemIndex;
	protected int numMaxAnswerItems;

	protected boolean isMSIE;

	public ResultBrowserSessionParam() {
	}

	public void setMSIE(boolean isMSIE) {
		this.isMSIE = isMSIE;
	}

	public void setSessionID(long sessionID) {
		this.sessionID = sessionID;
	}

	public void setUpdater(String updater) {
		this.updater = updater;
	}

	public void setViewMode(String viewMode) {
		this.viewMode = viewMode;
	}

	public void setCrossTableAxis(String axis) {
		this.axis = axis;
	}

	public void setAnswerItemIndex(int answerItemIndex) {
		this.answerItemIndex = answerItemIndex;
	}

	public void setNumMaxAnswerItems(int numMaxAnswerItems) {
		this.numMaxAnswerItems = numMaxAnswerItems;
	}

	public int getAnswerItemIndex() {
		return this.answerItemIndex;
	}

	public int getNumMaxAnswerItems() {
		return this.numMaxAnswerItems;
	}

	public String getViewMode() {
		return this.viewMode;
	}

	public String getCrossTableAxis() {
		return this.axis;
	}

	public boolean isMSIE() {
		return this.isMSIE;
	}

	public long getSessionID() {
		return this.sessionID;
	}

	public String getUpdater() {
		return this.updater;
	}

}
