/**
 * 
 */
package net.sqs2.omr.result.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import net.sqs2.omr.json.JSONUtil;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.session.logic.MarkAreaPreviewImageConstants;
import net.sqs2.omr.session.source.SessionSource;

public class MasterJSONWriter extends AbstractJSONWriter {

	public MasterJSONWriter(SessionSource sessionSource) {
		super(sessionSource);
	}

	@Override
	public String create(ResultBrowserSessionParam param) {
		ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		for (PageMaster master : this.sessionSource.getSessionSourceContentIndexer().getPageMasterList()) {
			HashMap<String, Object> map = new HashMap<String, Object>();
			map.put("text", master.getRelativePath());
			map.put("icon", "file_acrobat.gif");
			map.put("numPages", master.getNumPages());
			map.put("markAreaMarginHorizontal", MarkAreaPreviewImageConstants.HORIZONTAL_MARGIN);
			map.put("markAreaMarginVertical", MarkAreaPreviewImageConstants.VERTICAL_MARGIN);
			list.add(map);
		}
		StringBuilder sb = new StringBuilder();
		JSONUtil.printJSON(sb, list);
		return sb.toString();
	}
}
