package net.sqs2.omr.result.walker;

import java.io.IOException;
import java.util.List;

import net.sqs2.omr.event.MasterEvent;
import net.sqs2.omr.event.SessionEvent;
import net.sqs2.omr.event.SourceDirectoryEvent;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.model.SpreadSheet;
import net.sqs2.omr.session.source.SessionSource;

public class SpreadSheetWalker extends ResultWalker {
	SpreadSheet spreadSheet = null;
	public SpreadSheetWalker(SessionSource sessionSource, SpreadSheet spreadSheet) throws IOException{
		super(sessionSource);
		this.spreadSheet = spreadSheet;
	}

	@Override
	public Void call() throws WalkerStopException {
		SourceDirectory sourceDirectory = spreadSheet.getSourceDirectory();
		FormMaster master = (FormMaster) sourceDirectory.getPageMaster();

		SessionEvent sessionEvent = new SessionEvent(spreadSheet.getSessionID());
		List<PageMaster> masterList = this.sessionSource.getSessionSourceContentIndexer().getPageMasterList();
		MasterEvent masterEvent = new MasterEvent(sessionEvent, masterList.size());
		SourceDirectoryEvent sourceDirectoryEvent = new SourceDirectoryEvent(masterEvent, master, 0);
		sourceDirectoryEvent.setSourceDirectory(sourceDirectory);
		sourceDirectoryEvent.setIndex(0);
		sourceDirectoryEvent.setStart();
		processSourceDirectory(sourceDirectoryEvent, master);
		return null;
	}
}
