/**
 * DummyExportModule.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Author hiroya
 */

package net.sqs2.omr.result.walker;

import java.util.logging.Logger;

import net.sqs2.omr.event.MasterEvent;
import net.sqs2.omr.event.PageEvent;
import net.sqs2.omr.event.QuestionEvent;
import net.sqs2.omr.event.QuestionItemEvent;
import net.sqs2.omr.event.RowEvent;
import net.sqs2.omr.event.RowGroupEvent;
import net.sqs2.omr.event.SessionEvent;
import net.sqs2.omr.event.SourceDirectoryEvent;
import net.sqs2.omr.event.SpreadSheetEvent;
import net.sqs2.omr.event.SpreadSheetResultEventConsumer;

public class DummyExportModule implements SpreadSheetResultEventConsumer{

	public DummyExportModule() {
	}

	@Override
	public void startSession(SessionEvent sessionEvent) {
		Logger.getAnonymousLogger().info(
				"+Session:" + sessionEvent.getSessionID());
	}

	@Override
	public void endSession(SessionEvent sessionEvent) {
		Logger.getAnonymousLogger().info(
				"-Session:" + sessionEvent.getSessionID());
	}

	@Override
	public void startMaster(MasterEvent masterEvent) {
		Logger.getAnonymousLogger().info(
				"+Master:" + masterEvent.getFormMaster().getFileResourceID().getRelativePath());
	}

	@Override
	public void endMaster(MasterEvent masterEvent) {
		Logger.getAnonymousLogger().info(
				"-Master:" + masterEvent.getFormMaster().getFileResourceID().getRelativePath());
	}

	@Override
	public void startSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent) {
		Logger.getAnonymousLogger().info(
				"+SourceDirectory:" + sourceDirectoryEvent.getSourceDirectory().getPath());
	}

	@Override
	public void endSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent) {
		Logger.getAnonymousLogger().info(
				"-SourceDirectory:" + sourceDirectoryEvent.getSourceDirectory().getPath());
	}


	@Override
	public void startSpreadSheet(SpreadSheetEvent spreadSheetEvent) {
		Logger.getAnonymousLogger().info(
				"+SpreadSheet:" + spreadSheetEvent.getSourceDirectoryEvent().getSourceDirectory().getPath());
	}

	@Override
	public void endSpreadSheet(SpreadSheetEvent spreadSheetEvent) {
		Logger.getAnonymousLogger().info(
				"-SpreadSheet:" + spreadSheetEvent.getSourceDirectoryEvent().getSourceDirectory().getPath());
	}

	@Override
	public void startRowGroup(RowGroupEvent rowGroupEvent) {
		Logger.getAnonymousLogger().info("+RowGroup:" + rowGroupEvent.getSourceDirectory().getPath());
	}

	@Override
	public void endRowGroup(RowGroupEvent rowGroupEvent) {
		Logger.getAnonymousLogger().info("-RowGroup:" + rowGroupEvent.getSourceDirectory().getPath());
	}

	@Override
	public void startRow(RowEvent rowEvent) {
		Logger.getAnonymousLogger().info("+Row:" + rowEvent.getRowIndex());
	}

	@Override
	public void endRow(RowEvent rowEvent) {
		Logger.getAnonymousLogger().info("-Row:" + rowEvent.getRowIndex());
	}

	@Override
	public void startPage(PageEvent pageEvent) {
		//Logger.getAnonymousLogger().info("+Page:" + pageEvent.getPageIndex());
	}

	@Override
	public void endPage(PageEvent pageEvent) {
		//Logger.getAnonymousLogger().info("-Page:" + pageEvent.getPageIndex());
	}

	@Override
	public void startQuestion(QuestionEvent questionEvent) {
		//Logger.getAnonymousLogger().info(
		//		"+Q:" + questionEvent.getColumnIndex() + " " + questionEvent.getDefaultFormArea());
	}

	@Override
	public void endQuestion(QuestionEvent questionEvent) {
		//Logger.getAnonymousLogger().info(
		//		"-Q:" + questionEvent.getColumnIndex() + " " + questionEvent.getDefaultFormArea());
	}

	@Override
	public void startQuestionItem(QuestionItemEvent questionItemEvent) {
	}

	@Override
	public void endQuestionItem(QuestionItemEvent questionItemEvent) {
	}

}
