package net.sqs2.omr.result.servlet;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.omr.event.MasterEvent;
import net.sqs2.omr.event.SpreadSheetExportEventFilter;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.result.export.spreadsheet.ExcelExportModule;
import net.sqs2.omr.result.walker.ResultWalker;
import net.sqs2.omr.result.walker.WalkerStopException;
import net.sqs2.omr.result.writer.ResultBrowserSessionParam;
import net.sqs2.omr.result.writer.ResultBrowserSessionParamParser;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSources;
import net.sqs2.omr.util.HttpUtil;

public class XLSSpreadsheetServlet extends HttpServlet {
	private static final long serialVersionUID = 0L;

	public XLSSpreadsheetServlet() throws ServletException {
		super();
	}

	public static String getContextString() {
		return "exportXLS";
	}

	@Override
	public void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
		if (!HttpUtil.isLocalNetworkAccess(req)) {
			res.sendError(403, "Forbidden");
			return;
		}

		long sessionID = Long.parseLong(req.getParameter("sid"));

		SessionSource sessionSource = SessionSources.get(sessionID);
		ResultBrowserSessionParam param = ResultBrowserSessionParamParser.parse(
				new ResultBrowserSessionParam(), req);

		String filename = SessionSources.get(sessionID).getRootDirectory().getName() + ".xls";
		res.setContentType("application/vnd.ms-excel");
		res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
		OutputStream outputStream = new BufferedOutputStream(res.getOutputStream());

		final FormMaster master = (FormMaster) sessionSource.getSessionSourceContentIndexer().getPageMasterList().get(param.getSelectedMasterIndex());

		ResultWalker sessionResultWalker = new ResultWalker(sessionSource, new SpreadSheetExportEventFilter(){
			public boolean accept(MasterEvent sessionEvent) {
				return master.equals(sessionEvent.getFormMaster());
			}
		});
		sessionResultWalker.addEventConsumer(new ExcelExportModule(outputStream));
		//sessionResultWalker.addEventConsumer(new DummyExportModule());
		try{
			sessionResultWalker.call();
		}catch(WalkerStopException ex){
			ex.printStackTrace();
		}
		outputStream.flush();
	}

}
