/*

 ResultBrowserServlet.java

 Copyright 2008 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2008/01/13

 */
package net.sqs2.omr.result.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.omr.AppConstants;
import net.sqs2.omr.MarkReaderJarURIContext;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.model.AbstractPageTask;
import net.sqs2.omr.model.PageAreaCommand;
import net.sqs2.omr.model.PageID;
import net.sqs2.omr.model.PageTaskAccessor;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.result.writer.ErrorFormAreaContentsJSONWriter;
import net.sqs2.omr.result.writer.ErrorPageContentsJSONWriter;
import net.sqs2.omr.result.writer.FocusedFormAreaContentsJSONWriter;
import net.sqs2.omr.result.writer.MasterJSONWriter;
import net.sqs2.omr.result.writer.QuestionJSONWriter;
import net.sqs2.omr.result.writer.ResultBrowserSessionParam;
import net.sqs2.omr.result.writer.ResultBrowserSessionParamParser;
import net.sqs2.omr.result.writer.RowJSONWriter;
import net.sqs2.omr.result.writer.StatisticsContentsJSONWriter;
import net.sqs2.omr.result.writer.TableJSONWriter;
import net.sqs2.omr.result.writer.ViewModeUtil;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSources;
import net.sqs2.omr.util.HttpUtil;
import net.sqs2.servlet.FreeMarkerViewServlet;
import net.sqs2.sound.SoundManager;
import net.sqs2.util.Resource;

public class ResultBrowserServlet extends FreeMarkerViewServlet {
	private  static final long serialVersionUID = 0L;
	static private Resource resource = new Resource("messages");
	URL beepSoundURL;

	public ResultBrowserServlet(String skinName) throws ServletException {
		super(AppConstants.USER_CUSTOMIZE_CONSTANTS_DIR, skinName);
		try {
			this.beepSoundURL = new URL(MarkReaderJarURIContext.getSoundBaseURI() + "pi77.wav");
		} catch (MalformedURLException ex) {
			ex.printStackTrace();
		}
	}

	public static String getContextString() {
		return "e";
	}

	@Override
	protected String getTemplateFileName() {
		return "result.ftl";
	}

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		if (!req.getMethod().equals("GET") && !req.getMethod().equals("POST")) {
			res.sendError(405, "Method Not Allowed");
			return;
		}
		if (!HttpUtil.isLocalNetworkAccess(req)) {
			res.sendError(403, "Forbidden:"+req.getRemoteHost()+"("+req.getRemoteAddr()+")");
			return;
		}

		long sessionID = Long.parseLong(req.getParameter("sid"));
		SessionSource sessionSource = SessionSources.get(sessionID);
		ResultBrowserSessionParam param = ResultBrowserSessionParamParser.parse(
				new ResultBrowserSessionParam(), req);
		debugOut(req);

		if (sessionSource == null) {// && 0 <
			res.sendError(404, "Not Found");
			//res.setContentType("text/plain; charset=UTF-8");
			//PrintWriter w = new PrintWriter(res.getWriter());
			//w.println("ERROR_SESSION_HAS_NOT_STARTED");
			return;

		}else{
			String updater = param.getUpdater();
			if (updater == null) {
				// send HTML
				super.service(req, res);
			} else {
				// send JavaScript
				res.setContentType("text/javascript; charset=UTF-8");
				PrintWriter w = new PrintWriter(res.getWriter());
				if (updater.equals("t") || updater.equals("m")) {
					printRowsAsJSON(w, sessionSource, param);
				}
				printBodyAsJSON(w, sessionSource, param);
			}
		}
	}

	private void printRowsAsJSON(PrintWriter w, SessionSource sessionSource, ResultBrowserSessionParam param) {
		w.println(new RowJSONWriter(sessionSource, ResultBrowserServlet.resource).create(param));
	}

	private void printBodyAsJSON(PrintWriter w, SessionSource sessionSource, ResultBrowserSessionParam param) throws IOException {
		String viewMode = param.getViewMode();
		FormMaster master = (FormMaster) sessionSource.getSessionSourceContentIndexer().getPageMasterList()
				.get(param.getSelectedMasterIndex());
		if (ViewModeUtil.isFormEditMode(viewMode)) {
			new FocusedFormAreaContentsJSONWriter(w, sessionSource, param.getAnswerItemIndex(), 
					param.getNumMaxAnswerItems(), param.isMSIE()).create(master, param.getSelectedTableIndexSet(),
					param.getSelectedRowIndexSet(), param.getSelectedQuestionIndexSet());
		} else if (ViewModeUtil.isExportMode(viewMode) || ViewModeUtil.isSimpleChartViewMode(viewMode)
				|| ViewModeUtil.isCrossChartViewMode(viewMode) || ViewModeUtil.isCrossChartListViewMode(viewMode)
				|| ViewModeUtil.isGroupCrossChartViewMode(viewMode)
				|| ViewModeUtil.isGroupSimpleChartViewMode(viewMode)) {
			new StatisticsContentsJSONWriter(w, sessionSource, param.getViewMode()).create(master, 
					param.getSelectedTableIndexSet(), param.getSelectedRowIndexSet(), 
					param.getSelectedQuestionIndexSet());
		} else if (ViewModeUtil.isPageErrorViewMode(viewMode)) {
			new ErrorPageContentsJSONWriter(w, sessionSource).create(master, 
					param.getSelectedTableIndexSet(), param.getSelectedRowIndexSet(), 
					param.getSelectedQuestionIndexSet());
		} else if (ViewModeUtil.isLowReliabilityViewMode(viewMode) || ViewModeUtil.isNoAnswerErrorViewMode(viewMode)
				|| ViewModeUtil.isMultiAnswerErrorViewMode(viewMode)) {
			new ErrorFormAreaContentsJSONWriter(w, sessionSource, param.getAnswerItemIndex(), 
					param.getNumMaxAnswerItems(), param.isMSIE(), ViewModeUtil.isNoAnswerErrorViewMode(viewMode),
					ViewModeUtil.isMultiAnswerErrorViewMode(viewMode)).create(master, 
							param.getSelectedTableIndexSet(), param.getSelectedRowIndexSet(), 
							param.getSelectedQuestionIndexSet());
		} else {
			// Logger.getAnonymousLogger().severe("ERROR: v="+viewMode);
		}
		playSound();
	}

	private void playSound() {
		SoundManager.getInstance().play(this.beepSoundURL);
	}

	@Override
	protected Map<String,Object> createMap(long sessionID) {
		SessionSource sessionSource = SessionSources.get(sessionID);

		Map<String,Object> map = new HashMap<String,Object>();
		map.put("title", "SQSResultBrowser:"+sessionSource.getRootDirectory().getName());
		map.put("sourceDirectoryName", sessionSource.getRootDirectory().getName());
		map.put("masterOptions", new MasterJSONWriter(sessionSource).create(null));
		map.put("tableOptionsArray", new TableJSONWriter(sessionSource, ResultBrowserServlet.resource).create(null));
		map.put("questionOptionsArray", new QuestionJSONWriter(sessionSource).create(null));
		map.put("rowOptionsArray", "[]");
		map.put("cssPath", "/jar/css");
		map.put("imagePath", "/jar/image");
		map.put("javaScriptPath", "/jar/js");
		map.put("sid", Long.toString(sessionSource.getSessionID()));
		map.put("language", Locale.getDefault().getLanguage());
		return map;
	}

	@SuppressWarnings("unchecked")
	private void debugOut(HttpServletRequest req) {
		char delim = '?';
		try {
			//System.err.print(SQSHttpdManager.getBaseURI() + req.getRequestURI() + "?");
			System.err.print(req.getRequestURI() + "?");
		} catch (Exception ignore) {
		}
		for (Object o : req.getParameterMap().entrySet()) {
			Map.Entry<String, String[]> entry = (Map.Entry<String, String[]>) o;
			for (String value : entry.getValue()) {
				if (delim == '&') {
					System.err.print('&');
				}
				delim = '&';
				System.err.print(entry.getKey());
				System.err.print("=");
				System.err.print(value);
			}
		}
		System.err.println();
	}

	@SuppressWarnings("unused")
	private List<PageAreaCommand> getPageAreaCommandList(SourceDirectory sourceDirectory, int columnIndex, PageMaster pageMaster, FormArea defaultFormArea, PageTaskAccessor pageTaskAccessor) {
		PageID pageID = sourceDirectory.getPageID(columnIndex * pageMaster.getNumPages()
				+ defaultFormArea.getPage() - 1);
		AbstractPageTask pageTask = pageTaskAccessor.get(pageMaster, defaultFormArea.getPage(), pageID);
		return pageTask.getTaskResult().getPageAreaCommandList();
	}
}
