package net.sqs2.omr.result.servlet;

import javax.servlet.http.HttpServletRequest;

import net.sqs2.omr.result.writer.ResultBrowserSessionParamParser;
import net.sqs2.omr.result.writer.ResultContentSelectorParamParser;

public class ChartImageServletParamBuilder extends ResultBrowserSessionParamParser {
	public static ChartImageServletParam build(ChartImageServletParam chartServletParam, HttpServletRequest req) {
		ChartImageServletParam param = (ChartImageServletParam) ResultBrowserSessionParamParser.parse(
				chartServletParam, req);
		param.setWidth(ResultContentSelectorParamParser.getIntegerParameter(req, "w"));
		param.setHeight(ResultContentSelectorParamParser.getIntegerParameter(req, "h"));
		param.setWidth((param.width == -1) ? 400 : param.getWidth());
		param.setHeight((param.height == -1) ? 350 : param.getHeight());
		param.setType(req.getParameter("type"));
		param.setQuestionIndex(ResultContentSelectorParamParser.getIntegerParameter(req, "Q"));
		return param;
	}
}
