/*

 ChartServlet.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2008/01/13

 */
package net.sqs2.omr.result.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.result.chart.BarChart;
import net.sqs2.omr.result.chart.Legend;
import net.sqs2.omr.result.chart.LegendHandler;
import net.sqs2.omr.result.chart.PieChart;
import net.sqs2.omr.result.chart.StackedBarChart;
import net.sqs2.omr.result.writer.StatisticsContentsWriter;
import net.sqs2.omr.result.writer.ViewModeUtil;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSources;
import net.sqs2.omr.util.HttpUtil;

public class ChartImageServlet extends HttpServlet {
	private static final long serialVersionUID = 0L;

	public ChartImageServlet() throws ServletException {
		super();
	}

	public static String getContextString() {
		return "c";
	}

	static class LegendFactory {
		static Legend create(FormMaster master, int questionIndex) {
			return new Legend(questionIndex, master.getFormAreaList(questionIndex));
		}
	}

	@Override
	public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		if (!HttpUtil.isLocalNetworkAccess(req)) {
			res.sendError(403, "Forbidden");
			return;
		}

		SessionSource sessionSource = SessionSources.get(Long.parseLong(req.getParameter("sid")));
		int masterIndex = Integer.parseInt(req.getParameter("m"));

		FormMaster master = (FormMaster) sessionSource.getSessionSourceContentIndexer().getPageMasterList()
				.get(masterIndex);

		ChartImageServletParam param = ChartImageServletParamBuilder.build(new ChartImageServletParam(), req);
		StatisticsContentsWriter statisticsContentsFactory = new StatisticsContentsWriter(sessionSource,
				param.getViewMode());
		statisticsContentsFactory.create(master, param.getSelectedTableIndexSet(), param
				.getSelectedRowIndexSet(), param.getSelectedQuestionIndexSet());

		LegendHandler legendHandler = createLegendHandler(master, param);
		Legend[] legendArray = legendHandler.getLegendArray();

		res.setContentType("image/png");

		if (ViewModeUtil.isSimpleChartViewMode(param.getViewMode()) && legendArray.length == 1) {
			writeSimpleChart(res, param, statisticsContentsFactory, legendArray);
		} else if (ViewModeUtil.isGroupSimpleChartViewMode(param.getViewMode()) && legendArray.length == 1) {
			writeSimpleChart(res, param, statisticsContentsFactory, legendArray);
		} else if (ViewModeUtil.isCrossChartViewMode(param.getViewMode()) && legendArray.length == 2) {
			StackedBarChart.write(res.getOutputStream(), param.width, param.height, legendHandler,
					statisticsContentsFactory);
		} else if (ViewModeUtil.isGroupCrossChartViewMode(param.getViewMode()) && legendArray.length == 2) {
			StackedBarChart.write(res.getOutputStream(), param.width, param.height, legendHandler,
					statisticsContentsFactory);
		}
		res.getOutputStream().flush();
	}

	private void writeSimpleChart(HttpServletResponse res,
			ChartImageServletParam param,
			StatisticsContentsWriter statisticsContentsFactory,
			Legend[] legendArray) throws IOException {
		Legend legend = legendArray[0];
		if (legend.getDefaultFormArea().isMarkArea()) {
			if ("pie".equals(param.type)
					|| (param.type == null && legend.getDefaultFormArea().isSelect1())) {
				PieChart.write(res.getOutputStream(), param.width, param.height, legend
						.getQuestionIndex(), legend.getFormAreaList(), statisticsContentsFactory);
			} else if ("bar".equals(param.type)
					|| (param.type == null && legend.getDefaultFormArea().isSelect())) {
				BarChart.write(res.getOutputStream(), param.width, param.height, legend,
						statisticsContentsFactory);
			}
		}
	}

	private LegendHandler createLegendHandler(FormMaster master, ChartImageServletParam param) {
		Legend[] legendArray = null;

		int qindex = param.questionIndex;
		if (qindex != -1) {
			legendArray = new Legend[1];
			legendArray[0] = LegendFactory.create(master, qindex);
			return new LegendHandler(legendArray, null);
		} else {
			int i = 0;
			legendArray = new Legend[2];
			for (int questionIndex : param.getSelectedQuestionIndexSet()) {
				legendArray[i++] = LegendFactory.create(master, questionIndex);
			}
			String axis = param.getCrossTableAxis();
			if ("1,0".equals(axis)) {
				Legend tmp = legendArray[0];
				legendArray[0] = legendArray[1];
				legendArray[1] = tmp;
			}
			return new LegendHandler(legendArray, axis);
		}
	}

}
