package net.sqs2.omr.result.servlet;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.omr.event.MasterEvent;
import net.sqs2.omr.event.SpreadSheetExportEventFilter;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.result.export.spreadsheet.CSVExportModule;
import net.sqs2.omr.result.walker.ResultWalker;
import net.sqs2.omr.result.walker.WalkerStopException;
import net.sqs2.omr.result.writer.ResultBrowserSessionParam;
import net.sqs2.omr.result.writer.ResultBrowserSessionParamParser;
import net.sqs2.omr.session.source.SessionSource;
import net.sqs2.omr.session.source.SessionSources;
import net.sqs2.omr.util.HttpUtil;

public class CSVSpreadsheetServlet extends HttpServlet {
	private static final long serialVersionUID = 0L;

	public CSVSpreadsheetServlet() throws ServletException {
		super();
	}

	public static String getContextString() {
		return "exportCSV";
	}

	@Override
	public void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
		if (!HttpUtil.isLocalNetworkAccess(req)) {
			res.sendError(403, "Forbidden");
			return;
		}
		SessionSource sessionSource = SessionSources.get(Long.parseLong(req.getParameter("sid")));
		
		ResultBrowserSessionParam param = ResultBrowserSessionParamParser.parse(
				new ResultBrowserSessionParam(), req);
		
		int masterIndex = param.getSelectedMasterIndex();
		final FormMaster master = (FormMaster) sessionSource.getSessionSourceContentIndexer().getPageMasterList()
				.get(masterIndex);
		String title = null;
		if(1 < param.getSelectedTableIndexSet().size()){
			title = new File(master.getFileResourceID().getRelativePath()).getName();
		}else{
			int tableIndex = param.getSelectedTableIndexSet().first();
			SourceDirectory sourceDirectory = 
				sessionSource.getSessionSourceContentIndexer().getSourceDirectoryList(master).get(tableIndex);
			title = sourceDirectory.getDirectory().getName();
		}
		String filename = title + ".csv";

		res.setContentType("text/plain; charset="+CSVExportModule.DEFAULT_ENCODING);
		res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
		PrintWriter w = new PrintWriter(new OutputStreamWriter(
				new BufferedOutputStream(res.getOutputStream()), CSVExportModule.DEFAULT_ENCODING));
		
		ResultWalker sessionResultWalker = new ResultWalker(sessionSource, new SpreadSheetExportEventFilter(){
			public boolean accept(MasterEvent sessionEvent) {
				return master.equals(sessionEvent.getFormMaster());
			}
		});
		sessionResultWalker.addEventConsumer(new CSVExportModule(w));
		//sessionResultWalker.addEventConsumer(new DummyExportModule());
		try{
			sessionResultWalker.call();
		}catch(WalkerStopException ex){
			ex.printStackTrace();
		}
		w.flush();
	}
}
