package net.sqs2.omr.result.export.textarea;

import java.io.File;

import net.sqs2.omr.AppConstants;
import net.sqs2.omr.event.QuestionEvent;
import net.sqs2.omr.event.RowEvent;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.result.export.ResultDirectoryUtil;

public class TextAreaResultDirectoryUtil {
	public static File createTextAreaRowFile(QuestionEvent questionEvent, FormArea formArea) {
		RowEvent rowEvent = questionEvent.getRowEvent();
		// int rowIndex = rowEvent.getRowIndex();
		int rowIndexInRowGroup = rowEvent.getRowIndex() - rowEvent.getRowGroupEvent().getRowIndexBase();
		SourceDirectory sourceDirectory = rowEvent.getRowGroupEvent().getSourceDirectory();
		File textareaRowFile = createTextAreaRowFile(sourceDirectory, formArea, rowIndexInRowGroup);
		return textareaRowFile;
	}
		
	static private File createTextAreaRowFile(SourceDirectory sourceDirectory, FormArea formArea, int rowIndexInRowGroup) {
		File textAreaResultSubDirectory = ResultDirectoryUtil.createResultSubDirectory(sourceDirectory, "TEXTAREA");
		File textAreaColumnDirectory = new File(textAreaResultSubDirectory, Integer.toString(formArea.getColumnIndex()));
		if (!textAreaColumnDirectory.isDirectory()) {
			textAreaColumnDirectory.mkdirs();
		}
		return new File(textAreaColumnDirectory, Integer.toString(rowIndexInRowGroup) + "." + AppConstants.FORMAREA_IMAGE_FORMAT);
	}
}
