package net.sqs2.omr.result.export.textarea;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import net.sqs2.omr.event.PageEvent;
import net.sqs2.omr.event.QuestionEvent;
import net.sqs2.omr.event.QuestionItemEvent;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.model.PageAreaCommand;
import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.model.PageTaskResult;
import net.sqs2.omr.result.export.ResultDirectoryUtil;

public class TextAreaImageWriter {
	
	public static void exportTextAreaImageFile(QuestionItemEvent questionItemEvent){
		exportTextAreaImageFile(questionItemEvent.getPageEvent(),
				questionItemEvent.getQuestionEvent(), questionItemEvent.getFormArea());
	}

	private static void exportTextAreaImageFile(PageEvent pageEvent, QuestionEvent questionEvent, FormArea formArea) {
		byte[] bytes = getImageBytes(pageEvent, questionEvent, formArea);
		if (bytes == null) {
			return;
		}
		File textareaImageFile = TextAreaResultDirectoryUtil.createTextAreaRowFile(questionEvent, formArea);

		if (ResultDirectoryUtil.isValidOldFileIs(pageEvent, textareaImageFile)) {
			return;
		}

		try {
			OutputStream textAreaImageOutputStream = new BufferedOutputStream(new FileOutputStream(
					textareaImageFile));
			textAreaImageOutputStream.write(bytes);
			textAreaImageOutputStream.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	private static byte[] getImageBytes(PageEvent pageEvent, QuestionEvent questionEvent, FormArea formArea) {
		FormMaster master = questionEvent.getFormMaster();
		int formAreaIndexInPage = master.getAreaIndexInPage(formArea.getQID());
		PageTask pageTask = pageEvent.getPageTask();
		if (pageTask == null) {
			return null;
		}
		PageTaskResult taskResult = pageTask.getTaskResult();
		if (taskResult == null) {
			return null;
		}
		PageAreaCommand command = taskResult.getPageAreaCommandList().get(formAreaIndexInPage);
		return command.getImageByteArray();
	}
}
