/**
 * 
 */
package net.sqs2.omr.result.export.spreadsheet;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;

class HSSFObjectFactory implements SpreadSheetObjectFactory{
	/**
	 * 
	 */
	private final ExcelExportModule excelExportModule;

	/**
	 * @param excelExportModule
	 */
	HSSFObjectFactory(ExcelExportModule excelExportModule) {
		this.excelExportModule = excelExportModule;
	}
	
	public Workbook createWorkbook(){
		return new HSSFWorkbook();
		//return new XSSFWorkbook();
	}
	
	public RichTextString createRichTextString(String value){
		return new HSSFRichTextString(value);
	}
	
	public CellStyle getCellStyle(short fontColor, short backgroundColor) {
		String key = fontColor + "," + backgroundColor;
		CellStyle style = this.excelExportModule.getSpreadSheetWorkbook().getCellStyleCache().get(key);
		if (style == null) {
			style = createCellStyle(fontColor, backgroundColor);
			this.excelExportModule.getSpreadSheetWorkbook().getCellStyleCache().put(key, style);
		}
		return style;
	}

	private CellStyle createCellStyle(short fontColor, short backgroundColor) {
		Font font = getFont(fontColor);
		CellStyle style = this.excelExportModule.getSpreadSheetWorkbook().createCellStyle();
		style.setFont(font);
		style.setFillForegroundColor(backgroundColor);
		style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		return style;
	}

	private Font getFont(short fontColor) {
		Font font = this.excelExportModule.getSpreadSheetWorkbook().getFontCache().get(fontColor);
		if (font == null) {
			font = this.excelExportModule.getSpreadSheetWorkbook().createFont();
			font.setColor(fontColor);
			this.excelExportModule.getSpreadSheetWorkbook().getFontCache().put(fontColor, font);
		}
		return font;
	}

	public CellStyle getSelect1CellStyle(){
		return getCellStyle(HSSFColor.BLACK.index, HSSFColor.WHITE.index);
	}
	
	public CellStyle getSelectCellStyle(){
		return getCellStyle(HSSFColor.DARK_BLUE.index, HSSFColor.WHITE.index);
	}
	
	public CellStyle getErrorCellStyle(){
		return getCellStyle(HSSFColor.RED.index, HSSFColor.WHITE.index);
	}
	
	public CellStyle getTextAreaCellStyle(){
		return getCellStyle(HSSFColor.BLACK.index, HSSFColor.GREY_25_PERCENT.index);
	}
	
	public CellStyle getNoAnswerCellStyle(){
		return getCellStyle(HSSFColor.BLACK.index, HSSFColor.YELLOW.index);
	}
	
	public CellStyle getMultipleAnswersCellStyle(){
		return getCellStyle(HSSFColor.BLACK.index, HSSFColor.LIGHT_ORANGE.index);
	}
}