/**
 * 
 */
package net.sqs2.omr.result.export.model;


import net.sqs2.omr.event.QuestionEvent;
import net.sqs2.omr.event.RowGroupEvent;
import net.sqs2.omr.event.SessionEvent;
import net.sqs2.omr.event.SourceDirectoryEvent;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.model.MarkAreaAnswer;
import net.sqs2.omr.model.MarkAreaAnswerItemSet;
import net.sqs2.omr.model.SourceDirectory;
import net.sqs2.omr.model.SpreadSheet;
import net.sqs2.omr.result.export.MarkReadStatusReportModule;
import net.sqs2.omr.session.config.MarkRecognitionConfig;
import net.sqs2.omr.session.config.SourceConfig;

public class MarkAreaErrorModel extends MarkReadStatusReportModule {

	private MarkAreasTableModel noAnswerMarkAreasTableModel;
	private MarkAreasTableModel multipleAnswersMarkAreasTableModel;
	private int noAnswerMarkAreasSerial = 0;
	private int multipleAnswersMarkAreasSerial = 0;

	private float densityThreshold, recognitionMargin;

	public MarkAreaErrorModel() {
		super();
		this.noAnswerMarkAreasTableModel = new MarkAreasTableModel();
		this.multipleAnswersMarkAreasTableModel = new MarkAreasTableModel();
	}
	
	public MarkAreasTableModel getNoAnswerMarkAreasTableModel(){
		return noAnswerMarkAreasTableModel;
	}
	
	public MarkAreasTableModel getMultipleAnswersMarkAreasTableModel(){
		return multipleAnswersMarkAreasTableModel;
	}
	
	void reset() {
		this.noAnswerMarkAreasTableModel.clear();
		this.multipleAnswersMarkAreasTableModel.clear();
		this.noAnswerMarkAreasSerial = 0;
		this.multipleAnswersMarkAreasSerial = 0;
	}

	@Override
	public void startSession(SessionEvent sessionEvent) {
		super.startSession(sessionEvent);
		reset();
	}

	@Override
	public void startSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent) {
		super.startSourceDirectory(sourceDirectoryEvent);
		SourceDirectory sourceDirectory = sourceDirectoryEvent.getSourceDirectory();
		MarkRecognitionConfig config = ((SourceConfig)sourceDirectory.getConfiguration().getConfig().getSourceConfig())
				.getMarkRecognitionConfig();
		this.densityThreshold = config.getDensity();
		this.recognitionMargin = config.getDoubleMarkIgnoranceThreshold();
	}

	@Override
	public void endQuestion(QuestionEvent questionEvent) {

		super.endQuestion(questionEvent); // do not remove

		FormArea defaultFormArea = questionEvent.getDefaultFormArea();
		if (defaultFormArea.isMarkArea()) {

			MarkAreaAnswer answer = (MarkAreaAnswer) questionEvent.getAnswer();
			MarkAreaAnswerItemSet answerItemSet = answer.createMarkAreaAnswerItemSet();
			int columnIndex = questionEvent.getDefaultFormArea().getColumnIndex();
			int pageStart = questionEvent.getDefaultFormArea().getPage();

			if (defaultFormArea.isSelect1()) {

				processSelect1Errors(questionEvent, answerItemSet, columnIndex, pageStart);

			} else if (defaultFormArea.isSelect()) {

			} else {
				throw new RuntimeException("invalid formArea type");
			}

		} else if (defaultFormArea.isTextArea()) {
			/*
			 * List<PageAreaCommand> pageAreaCommandList =
			 * ContentsFactoryUtil.createPageAreaCommandListParQuestion
			 * (sessionSource, master, sourceDirectory, pageTaskAccessor,
			 * rowIndex, questionEvent.getColumnIndex()); PageAreaCommand
			 * command = pageAreaCommandList.get(0); byte[] bytes =
			 * command.getImageByteArray(); // TODO
			 */
			// do nothing
			// do nothing
		} else {
			throw new RuntimeException("invalid formArea type");
		}
	}

	private void processSelect1Errors(QuestionEvent questionEvent, MarkAreaAnswerItemSet answerItemSet, int columnIndex, int pageStart) {
		boolean[] isMarked = answerItemSet.getIsSelectedBooleanArray(this.densityThreshold, this.recognitionMargin);
		int pageEnd = questionEvent.getFormAreaList().get(isMarked.length - 1).getPage();

		int numSelected = answerItemSet.getNumSelected(this.densityThreshold, this.recognitionMargin);
		if (numSelected == 1) {
			return;
		}
		int rowIndex = questionEvent.getRowEvent().getIndex();
		RowGroupEvent rowGroupEvent = questionEvent.getRowEvent().getRowGroupEvent();
		int rowGroupRowIndex = rowGroupEvent.getIndex();
		SpreadSheet spreadSheet = rowGroupEvent.getSpreadSheetEvent().getSpreadSheet();
		SourceDirectory rowGroupSourceDirectory = rowGroupEvent.getSourceDirectory();

		int tableIndex = questionEvent.getRowEvent().getRowGroupEvent().getSourceDirectory().getID();
		
		if (numSelected == 0) {
			this.noAnswerMarkAreasTableModel.addRow(++this.noAnswerMarkAreasSerial, 
					spreadSheet,
					rowGroupSourceDirectory, rowGroupRowIndex, pageStart, pageEnd, 
					tableIndex,
					rowIndex,
					columnIndex);
		} else {
			this.multipleAnswersMarkAreasTableModel.addRow(++this.multipleAnswersMarkAreasSerial,
					spreadSheet, rowGroupSourceDirectory, rowGroupRowIndex, pageStart, pageEnd,
					tableIndex,
					rowIndex, 
					columnIndex);
		}
	}
}
