/**
 * SpreadSheetExportEventAdapter.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Author hiroya
 */

package net.sqs2.omr.result.export;


import java.util.List;

import net.sqs2.omr.event.PageEvent;
import net.sqs2.omr.event.QuestionEvent;
import net.sqs2.omr.event.QuestionItemEvent;
import net.sqs2.omr.event.RowEvent;
import net.sqs2.omr.event.RowGroupEvent;
import net.sqs2.omr.event.SourceDirectoryEvent;
import net.sqs2.omr.event.SpreadSheetEvent;
import net.sqs2.omr.event.SpreadSheetResultEventConsumer;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.model.Answer;
import net.sqs2.omr.model.MarkAreaAnswer;
import net.sqs2.omr.model.MarkAreaAnswerItem;
import net.sqs2.omr.model.PageTask;
import net.sqs2.omr.session.config.MarkRecognitionConfig;
import net.sqs2.omr.session.config.SourceConfig;

public class SessionResultExportModule extends AbstractSessionResultEventAdapter implements SpreadSheetResultEventConsumer {

	private float densityThreshold;
	private float doubleMarkIgnoranceThreshold;
	
	private int[][] valueTotalMatrix;
	private int[] numNoValues;
	private int[] numMultipleValues;
	private long[] targetLastModifiedArray;

	public float getDensityThreshold() {
		return densityThreshold;
	}

	public float getDoubleMarkIgnoranceThreshold() {
		return doubleMarkIgnoranceThreshold;
	}

	public int[][] getValueTotalMatrix() {
		return valueTotalMatrix;
	}

	public int[] getNumNoValues() {
		return numNoValues;
	}

	public int[] getNumMultipleValues() {
		return numMultipleValues;
	}

	public long[] getTargetLastModifiedArray() {
		return targetLastModifiedArray;
	}

	@Override
	public void startQuestion(QuestionEvent questionEvent) {
		List<FormArea> formAreaList = questionEvent.getFormAreaList();
		FormArea formArea = formAreaList.get(0);

		Answer answer = questionEvent.getRowEvent().getRow().getAnswer(questionEvent.getColumnIndex());
		if (answer == null) {
			return;
		}
		if (formArea.isSelect1()) {
			int numSelectedItemIndex = -1;
			int numSelected = 0;

			List<MarkAreaAnswerItem> markAreaAnswerItemList =
				((MarkAreaAnswer) answer).createMarkAreaAnswerItemSet().getMarkedAnswerItems(this.densityThreshold,
					this.doubleMarkIgnoranceThreshold);
			
			for (MarkAreaAnswerItem markAreaAnswerItem : markAreaAnswerItemList){ 
				numSelectedItemIndex = markAreaAnswerItem.getItemIndex();
				numSelected++;
			}

			if (numSelected == 0) {
				this.numNoValues[formArea.getColumnIndex()]++;
			} else if (numSelected == 1) {
				this.valueTotalMatrix[formArea.getColumnIndex()][numSelectedItemIndex]++;
			} else {
				this.numMultipleValues[formArea.getColumnIndex()]++;
			}

		} else if (formArea.isSelect()) {
			for (int itemIndex = 0; itemIndex < formAreaList.size(); itemIndex++) {
				MarkAreaAnswerItem markAreaAnswerItem = ((MarkAreaAnswer) answer)
						.getMarkAreaAnswerItem(itemIndex);
				if (markAreaAnswerItem
						.isSelectMultiSelected(((MarkAreaAnswer) answer), this.densityThreshold)) {
					this.valueTotalMatrix[formArea.getColumnIndex()][itemIndex]++;
				}
			}
		}
	}

	@Override
	public void startQuestionItem(QuestionItemEvent questionItemEvent) {
		FormArea formArea = questionItemEvent.getFormArea();
		if (formArea.isTextArea()) {
		} else if (formArea.isMarkArea()) {
			PageTask pageTask = questionItemEvent.getPageEvent().getPageTask();
			long targetFileLastModified = pageTask.getPageID().getFileResourceID().getLastModified();
			long configHandlerLastModified = pageTask.getConfigHandlerFileResourceID().getLastModified();
			long masterFileLastModified = questionItemEvent.getQuestionEvent().getFormMaster()
					.getLastModified();
			long prevTargetLastModified = this.targetLastModifiedArray[formArea.getColumnIndex()];

			this.targetLastModifiedArray[formArea.getColumnIndex()] = max(max(targetFileLastModified,
					configHandlerLastModified), max(masterFileLastModified, prevTargetLastModified));
		}
	}

	public void endPage(PageEvent pageEvent) {
		// TODO Auto-generated method stub

	}

	public void endQuestion(QuestionEvent questionEvent) {
		// TODO Auto-generated method stub

	}

	public void endQuestionItem(QuestionItemEvent questionItemEvent) {
		// TODO Auto-generated method stub

	}

	public void endRow(RowEvent rowEvent) {
		// TODO Auto-generated method stub

	}

	public void endRowGroup(RowGroupEvent rowGroupEvent) {
		// TODO Auto-generated method stub

	}

	public void startPage(PageEvent pageEvent) {
		// TODO Auto-generated method stub

	}

	public void startRow(RowEvent rowEvent) {
		// TODO Auto-generated method stub

	}

	public void startRowGroup(RowGroupEvent rowGroupEvent) {
		// TODO Auto-generated method stub

	}
	
	@Override
	public void startSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent) {
		MarkRecognitionConfig config = ((SourceConfig)sourceDirectoryEvent.getSourceDirectory().getConfiguration()
		.getConfig().getSourceConfig()).getMarkRecognitionConfig();
		this.densityThreshold = config.getDensity();
		this.doubleMarkIgnoranceThreshold = config.getDoubleMarkIgnoranceThreshold();
	}

	@Override
	public void endSourceDirectory(SourceDirectoryEvent sourceDirectoryEvent) {
	}


	@Override
	public void startSpreadSheet(SpreadSheetEvent spreadSheetEvent) {
		FormMaster master = spreadSheetEvent.getFormMaster();

		this.valueTotalMatrix = new int[master.getNumColumns()][];
		this.numNoValues = new int[master.getNumColumns()];
		this.numMultipleValues = new int[master.getNumColumns()];
		this.targetLastModifiedArray = new long[master.getNumColumns()];

		for (int columnIndex = 0; columnIndex < master.getNumColumns(); columnIndex++) {
			List<FormArea> formAreaList = master.getFormAreaList(columnIndex);
			FormArea formArea = formAreaList.get(0);
			if (formArea.isSelect1() || formArea.isSelect()) {
				this.valueTotalMatrix[columnIndex] = new int[formAreaList.size()];
			}
		}
	}

	@Override
	public void endSpreadSheet(SpreadSheetEvent spreadSheetEvent) {
	}
	
	private long max(long a, long b) {
		if (a <= b) {
			return b;
		} else {
			return a;
		}
	}

}
