package net.sqs2.omr.model;


public class SpreadSheet {

	private long sessionID;
	private SourceDirectory sourceDirectory;

	public SpreadSheet(long sessionID, SourceDirectory sourceDirectory) {
		this.sessionID = sessionID;
		this.sourceDirectory = sourceDirectory;
	}

	public long getSessionID() {
		return this.sessionID;
	}

	public SourceDirectory getSourceDirectory() {
		return this.sourceDirectory;
	}

	public int getNumRows() {
		return this.sourceDirectory.getNumPageIDsTotal() / this.sourceDirectory.getPageMaster().getNumPages();
	}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof SpreadSheet)) {
			return false;
		}
		return this.sourceDirectory.equals(((SpreadSheet) o).getSourceDirectory());
	}
}
