package net.sqs2.omr.model;


public class RowID {
	private SpreadSheet spreadSheet;
	private int rowIndex;

	public RowID(SpreadSheet spreadSheet, int rowIndex) {
		this.spreadSheet = spreadSheet;
		this.rowIndex = rowIndex;
	}

	public SpreadSheet getSpreadSheet() {
		return this.spreadSheet;
	}

	public int getRowIndex() {
		return this.rowIndex;
	}

	public String toString(){
		return spreadSheet.getSourceDirectory().getPath()+" "+rowIndex;
	}

	public boolean equals(Object o){
		try{
			RowID rowID = (RowID)o;
			return rowIndex == rowID.getRowIndex() &&
					spreadSheet.getSourceDirectory().getPath().equals(rowID.getSpreadSheet().getSourceDirectory().getPath());
			
		}catch(ClassCastException ignore){
			return false;
		}
	}
}
