/**
 * MarkAreaAnswerItemSet.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Author hiroya
 */

package net.sqs2.omr.model;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

public class MarkAreaAnswerItemSet extends TreeSet<MarkAreaAnswerItem> {
	private static final long serialVersionUID = 0L;

	public MarkAreaAnswerItemSet(MarkAreaAnswer answer) {
		super(new Comparator<MarkAreaAnswerItem>() {
			public int compare(MarkAreaAnswerItem b, MarkAreaAnswerItem a) {
				double value = Math.ceil(a.getDensity() - b.getDensity());
				if (0 == value) {
					return a.getItemIndex() - b.getItemIndex();
				} else if (0 < value) {
					return (int) Math.ceil(value);
				} else {
					return (int) Math.floor(value);
				}
			}

			@Override
			public boolean equals(Object obj) {
				return false;
			}
		});

		for (MarkAreaAnswerItem markAreaAnswerItem : answer.getMarkAreaAnswerItemArray()) {
			add(markAreaAnswerItem);
		}
	}

	public LinkedList<MarkAreaAnswerItem> getMarkedAnswerItems(float densityThreshold, float doubleMarkIgnoranceThreshold) {
		LinkedList<MarkAreaAnswerItem> list = new LinkedList<MarkAreaAnswerItem>();
		for (Iterator<MarkAreaAnswerItem> it = iterator(); it.hasNext();) {
			MarkAreaAnswerItem item = it.next();
			if (isSelected(densityThreshold, doubleMarkIgnoranceThreshold, last(), item)) {
				list.add(item);
			}
		}
		return list;
	}

	public boolean[] getIsSelectedBooleanArray(float densityThreshold, float doubleMarkIgnoranceThreshold) {
		boolean[] ret = new boolean[this.size()];
		for (Iterator<MarkAreaAnswerItem> it = iterator(); it.hasNext();) {
			MarkAreaAnswerItem item = it.next();
			if (isSelected(densityThreshold, doubleMarkIgnoranceThreshold, last(), item)) {
				ret[item.getItemIndex()] = true;
			}
		}
		return ret;
	}

	public int getNumSelected(float densityThreshold, float doubleMarkIgnoranceThreshold) {
		int ret = 0;
		for (Iterator<MarkAreaAnswerItem> it = iterator(); it.hasNext();) {
			MarkAreaAnswerItem item = it.next();
			if (isSelected(densityThreshold, doubleMarkIgnoranceThreshold, last(), item)) {
				ret++;
			}
		}
		return ret;

	}

	private boolean isSelected(float densityThreshold, float doubleMarkIgnoranceThreshold, MarkAreaAnswerItem last, MarkAreaAnswerItem item) {
		return (item.isManualMode() && item.isManualSelected())
				|| (item.getDensity() < densityThreshold && (last == item || item.getDensity() < doubleMarkIgnoranceThreshold));
	}

}
