package net.sqs2.omr.model;

import java.io.Serializable;

import net.sqs2.util.FileResourceID;

public class AbstractPageTask extends AbstractTask implements Serializable {

	private static final long serialVersionUID = 0L;

	protected String sourceDirectoryRootPath;
	protected FileResourceID masterResourceID;
	protected FileResourceID configResourceID;
	protected PageTaskResult taskResult = null;
	protected PageTaskError taskError = null;

	AbstractPageTask() {
	}

	AbstractPageTask(String sourceDirectoryRootPath, FileResourceID masterResourceID,
			FileResourceID configResourceID, long sessionID) {
		this.sourceDirectoryRootPath = sourceDirectoryRootPath;
		this.masterResourceID = masterResourceID;
		this.configResourceID = configResourceID;
		this.sessionID = sessionID;
	}

	public String getSourceDirectoryRootPath() {
		return this.sourceDirectoryRootPath;
	}

	public FileResourceID getMasterFileResourceID() {
		return this.masterResourceID;
	}

	public FileResourceID getConfigHandlerFileResourceID() {
		return this.configResourceID;
	}

	public PageTaskResult getTaskResult() {
		return this.taskResult;
	}

	public void setTaskResult(PageTaskResult taskResult) {
		this.taskResult = taskResult;
	}

	public PageTaskError getTaskError() {
		return this.taskError;
	}

	public void setTaskError(PageTaskError taskError) {
		this.taskError = taskError;
	}

}
