/*

 ShutdownTask.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package net.sqs2.omr.app.service;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;

import net.sqs2.omr.session.broker.impl.PageTaskExecutorPeerBroker;
import net.sqs2.omr.session.broker.impl.RemotePageTaskExecutorPeer;
import net.sqs2.omr.session.service.MarkReaderSessionService;
import net.sqs2.omr.session.service.MarkReaderSessionServices;
import net.sqs2.omr.session.source.impl.SessionSourceServerImpl;

public class ShutdownAppService implements Callable<Void>{
	private RemotePageTaskExecutorPeer networkPeer;
	private PageTaskExecutorPeerBroker localTaskBroker;
	
	public ShutdownAppService(RemotePageTaskExecutorPeer networkPeer, PageTaskExecutorPeerBroker localTaskBroker){
		this.networkPeer = networkPeer;
		this.localTaskBroker = localTaskBroker;
	}
	
	public Void call(){
		Collection<MarkReaderSessionService> sessions = MarkReaderSessionServices.getSessions();
		Iterator<MarkReaderSessionService> sessionsIterator = sessions.iterator();
		MarkReaderSessionService[] sessionsArray = new MarkReaderSessionService[sessions.size()];

		for (int i = 0; i < sessions.size(); i++) {
			sessionsArray[i] = sessionsIterator.next();
		}
		for (MarkReaderSessionService session : sessionsArray) {
			new StopSessionService(session.getSourceDirectoryRootFile()).call();
			new CloseSessionService(session.getSourceDirectoryRootFile()).call();
		}
		this.networkPeer.shutdown();
		if(this.localTaskBroker != null){
			this.localTaskBroker.stop();
			this.localTaskBroker.shutdown();
		}
		unexportSessionService();
		return null;
	}
	
	private void unexportSessionService() {
		try {
			SessionSourceServerImpl sessionService = SessionSourceServerImpl.getInstance();
			if (sessionService != null) {
				sessionService.close();
				UnicastRemoteObject.unexportObject(sessionService, false);
			}
		} catch (RemoteException ignore) {
		}
	}

}