/*

 RemoveResultFoldersTask.java

 Copyright 2009 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package net.sqs2.omr.app.service;

import java.io.File;
import java.util.concurrent.Callable;

import net.sqs2.omr.AppConstants;
import net.sqs2.util.FileUtil;

public class RemoveResultFoldersService implements Callable<Void>{
	File targetDirectory;
	public RemoveResultFoldersService(File targetDirectory){
		this.targetDirectory = targetDirectory;
	}
	
	public Void call(){
		removeResultFolders(this.targetDirectory);
		return null;
	}

	private static void removeResultFolders(File targetDirectory) {
		File resultDirectory = new File(targetDirectory, AppConstants.getResultDirectoryName());
		if (resultDirectory.exists()) {
			FileUtil.deleteDirectory(resultDirectory);
		}
		for (File targetSubFile : targetDirectory.listFiles()) {
			if (targetSubFile.isDirectory()) {
				removeResultFolders(targetSubFile);
			}
		}
	}
}