package net.sqs2.omr.app.service;

import java.io.File;
import java.io.IOException;

import net.sqs2.omr.cache.CacheConstants;
import net.sqs2.omr.master.FormMasterFactory;
import net.sqs2.omr.session.broker.impl.PageTaskExecutorSessionServerDispatcher;
import net.sqs2.omr.session.broker.impl.RemotePageTaskExecutorPeer;
import net.sqs2.omr.session.service.MarkReaderSessionService;
import net.sqs2.omr.session.service.MarkReaderSessionServices;

public class CreateSessionService extends ManageSessionService<MarkReaderSessionService>{

	private RemotePageTaskExecutorPeer networkPeer;
	private FormMasterFactory formMasterFactory;
	private PageTaskExecutorSessionServerDispatcher localTaskExecutorEnv;
	
	public CreateSessionService(RemotePageTaskExecutorPeer networkPeer, FormMasterFactory formMasterFactory, PageTaskExecutorSessionServerDispatcher localTaskExecutorEnv, File sourceDirectoryRoot){
		super(sourceDirectoryRoot);
		this.networkPeer = networkPeer;
		this.formMasterFactory = formMasterFactory;
		this.localTaskExecutorEnv = localTaskExecutorEnv;
	}

	public MarkReaderSessionService call()throws IOException{
		synchronized(CreateSessionService.class){
			if (sourceDirectoryRoot == null || ! sourceDirectoryRoot.isDirectory()){
				throw new IOException("DIRECTORY IO ERROR in: " + sourceDirectoryRoot);
			}
			if(sourceDirectoryRoot.getName().endsWith(CacheConstants.CACHE_ROOT_DIRNAME)){
				throw new IOException("DIRECTORY INVALID:"+sourceDirectoryRoot);
			}
			if(MarkReaderSessionServices.contains(sourceDirectoryRoot)){
				throw new IOException("DIRECTORY ALREADY EXISTS:"+sourceDirectoryRoot);
			}
			return MarkReaderSessionServices.create(sourceDirectoryRoot, this.networkPeer, this.formMasterFactory, this.localTaskExecutorEnv);
		}
	}
}
