package net.sqs2.omr.app.service;

import java.io.File;

import net.sqs2.omr.master.PageMasterAccessor;
import net.sqs2.omr.model.PageTaskAccessor;
import net.sqs2.omr.model.PageTaskHolder;
import net.sqs2.omr.session.service.MarkReaderSessionService;
import net.sqs2.omr.session.service.MarkReaderSessionServices;
import net.sqs2.omr.session.source.SessionSourceContentAccessor;

public class ClearSessionService extends ManageSessionService<Void>{	
	
	public ClearSessionService(File sourceDirectoryRoot){
		super(sourceDirectoryRoot);
	}
	
	public Void call(){
		clearCache(sourceDirectoryRoot);
		return null;
	}
	
	private void clearCache(final File sourceDirectoryRoot) {
		MarkReaderSessionService session = MarkReaderSessionServices.get(sourceDirectoryRoot);
		SessionSourceContentAccessor accessor = session.getSessionSource().getSessionSourceContentAccessor();
		PageMasterAccessor pageMasterAccessor = accessor.getPageMasterAccessor();
		pageMasterAccessor.removeAll();
		PageTaskHolder taskHolder = session.getTaskHolder();
		taskHolder.clear();
		PageTaskAccessor taskAccessor = accessor.getPageTaskAccessor();
		if (taskAccessor != null) {
			taskAccessor.removeAll();
		}
	}


}
