/*

 FormMasterFactory.java
 
 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2005/02/26

 */
package net.sqs2.omr.app;

import java.io.File;

import net.sqs2.omr.master.FormMasterFactory;
import net.sqs2.omr.master.PageMaster;
import net.sqs2.omr.master.PageMasterException;
import net.sqs2.omr.master.PageMasterFactory;
import net.sqs2.omr.master.pdfbookmark.PDFBookmarkFormMasterFactory;
import net.sqs2.omr.master.sqm.PDFAttachmentFormMasterFactory;
import net.sqs2.omr.master.sqm.XMLFormMasterFactory;

public class MergedFormMasterFactory implements PageMasterFactory, FormMasterFactory {

	public static final String SUFFIX_PDF = ".pdf";
	public static final String SUFFIX_SQM = ".sqm";

	PDFAttachmentFormMasterFactory pdfAttachmentFormMasterFactory = new PDFAttachmentFormMasterFactory();
	PDFBookmarkFormMasterFactory pdfBookmarkFormMasterFactory = new PDFBookmarkFormMasterFactory();
	XMLFormMasterFactory xmlFormMasterFactory = new XMLFormMasterFactory();

	/* (non-Javadoc)
	 * @see net.sqs2.omr.app.IFormMasterFactory#create(java.io.File, java.lang.String)
	 */
	public PageMaster create(File sourceDirectoryRoot, String masterPath) throws PageMasterException {
		if (masterPath.endsWith(SUFFIX_PDF)) {
			return createMasterByPDFFile(sourceDirectoryRoot, masterPath);
		} else if (masterPath.endsWith(SUFFIX_SQM)) {
			return createMasterBySQMFile(sourceDirectoryRoot, masterPath);
		}
		return null;
	}

	private PageMaster createMasterByPDFFile(File sourceDirectoryRoot, String masterPath) throws PageMasterException {
		PageMasterException ex = null;
		PageMaster master = null;
		try {
			master = this.pdfAttachmentFormMasterFactory.create(sourceDirectoryRoot, masterPath);
			if (master != null) {
				return master;
			}
		} catch (PageMasterException expt) {
			ex = expt;
		}
		master = this.pdfBookmarkFormMasterFactory.create(sourceDirectoryRoot, masterPath);
		if (master != null) {
			return master;
		}
		throw ex;
	}

	private PageMaster createMasterBySQMFile(File sourceDirectoryRoot, String masterPath) throws PageMasterException {
		return this.xmlFormMasterFactory.create(sourceDirectoryRoot, masterPath);
	}
}
