/*

App.java

Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Created on 2007/09/05

 */

package net.sqs2.omr;

import java.io.File;

import net.sqs2.util.Resource;

public class AppConstants {
	// public static final String SKIN_ID = "smp";
	public static final String SKIN_ID = "sqs";
	static Resource appResource = new Resource("app-" + SKIN_ID);

	public static final String BUILD_NAME = appResource.getString("build.name");
	public static final String COPYRIGHT_NOTICE = appResource.getString("copyright.notice");
	public static final String GROUP_ID = appResource.getString("group.id");

	public static final String APP_NAME = appResource.getString("app.name");
	public static final String APP_ID = appResource.getString("app.id");
	public static final String BUILD_ID = appResource.getString("build.id");

	public static final String MAIN_ICON = appResource.getString("main.icon");
	public static final String SUB_ICON = appResource.getString("sub.icon");
	
	public static final String[] RESULT_DIRNAMES = appResource.getString("result.dirnames").split(",");

	public static final String RELEASE_ID = APP_ID + "_" + BUILD_ID;

	public static final String SOURCE_CONFIG_FILENAME = "config.xml";
	public static final String SOURCE_CONFIG_FILENAME_SUFFIX = ".xml";

	public static String resultDirectoryName = RESULT_DIRNAMES[0];

	public static final File USER_CUSTOMIZE_CONSTANTS_DIR = new File(
			System.getProperty(appResource.getString("MarkReaderConstants.USER_HOME_PROPERTY_KEY")) + File.separatorChar + '.' + AppConstants.GROUP_ID + File.separatorChar + AppConstants.APP_ID); //$NON-NLS-1$

	public static final File USER_CUSTOMIZE_DEFAULT_CONFIG_FILE = new File(USER_CUSTOMIZE_CONSTANTS_DIR, SOURCE_CONFIG_FILENAME);

	public static final String MULTICAST_ADDRESS = AppConstants.appResource
	.getString("MarkReaderConstants.MULTICAST_ADDRESS"); // FIXME: configurable address //$NON-NLS-1$
	public static final String TASK_EXECUTION_SOUND_FILENAME = AppConstants.appResource
			.getString("MarkReaderConstants.TASK_EXECUTION_SOUND_FILENAME"); //$NON-NLS-1$
	public static final String SOURCE_DIRECTORY_ROOT_KEY_IN_PREFERENCES = AppConstants.appResource
			.getString("MarkReaderConstants.SOURCE_DIRECTORY_ROOT_KEY_IN_PREFERENCES"); //$NON-NLS-1$
	public static final String SESSION_START_FANFARE_SOUND_FILENAME = AppConstants.appResource
			.getString("MarkReaderConstants.SESSION_START_FANFARE_SOUND_FILENAME"); //$NON-NLS-1$
	public static final String FORMAREA_IMAGE_FORMAT = AppConstants.appResource
			.getString("MarkReaderConstants.FORMAREA_IIMAGE_FORMAT"); //$NON-NLS-1$

	public static void setResultDirectoryName(String value) {
		resultDirectoryName = value;
	}

	public static String getResultDirectoryName() {
		return resultDirectoryName;
	}

}
