package net.sqs2.omr.result;

import java.awt.Rectangle;

import junit.framework.TestCase;

public class RectImagePathInfoTest extends TestCase{
	
	RectImagePathInfo[] api = new RectImagePathInfo[]{
			new RectImagePathInfo("/hoge/foo/bar.png", 0, 1, 100, new Rectangle(2,3,4,5), "gif"),
			new RectImagePathInfo("/hoge/foo/bar.png", 10, 21, 99, new Rectangle(32,43,54,65), "gif")
	};
	
	
	public void testToPathInfo(){
		assertEquals("/hoge/foo/bar.png/0/1/100/2-3/4-5.gif", api[0].toPathInfo());
		assertEquals("/hoge/foo/bar.png/10/21/99/32-43/54-65.gif", api[1].toPathInfo());
	}
	
	public void testParse(){
		assertEquals(api[0], RectImagePathInfo.parse(api[0].toPathInfo()));
		assertEquals(api[1], RectImagePathInfo.parse(api[1].toPathInfo()));
	}
}
