package net.sqs2.omr.result;

import junit.framework.TestCase;

public class AreaImagePathInfoTest extends TestCase{
	
	AreaImagePathInfo[] api = new AreaImagePathInfo[]{
			new AreaImagePathInfo("/hoge/foo/bar.png", 0, 1, 2, 3, "gif"),
			new AreaImagePathInfo("/hoge/foo/bar.png", 10, 21, 32, 43, "gif")
	};
	
	
	public void testToPathInfo(){
		assertEquals("/hoge/foo/bar.png/0/1-2-3.gif", api[0].toPathInfo());
		assertEquals("/hoge/foo/bar.png/10/21-32-43.gif", api[1].toPathInfo());
	}
	
	public void testParse(){
		assertEquals(api[0], AreaImagePathInfo.parse(api[0].toPathInfo()));
		assertEquals(api[1], AreaImagePathInfo.parse(api[1].toPathInfo()));
	}
}
