package net.sqs2.omr.master.pdfbookmark;

import java.io.File;

import junit.framework.TestCase;
import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.master.PageMasterAccessor;
import net.sqs2.omr.master.FormMaster;

public class PDFBookmarkFormMasterAccessorTest extends TestCase {
	
	public void testSetAndGet(){
		try{
			
			FormMaster master1 = (FormMaster)PDFBookmarkFormMasterFactory.createInstance().create(0, new File("/home/hiroya/Desktop/sqs-sample-images"), "sqs.pdf");
			PageMasterAccessor omrMasterAccessor =  new PageMasterAccessor(new File("/tmp"), new File("/tmp/hoge"));
			
			omrMasterAccessor.put(master1);

			PageMaster master2 = (PageMaster)omrMasterAccessor.get("sqs.pdf");
			
			System.err.println("master1 "+master1);
			System.err.println("master2 "+master2);
			
			assertEquals(master2.getLastModified(), master1.getLastModified());
			
			omrMasterAccessor.close();
		}catch(Exception ex){
			ex.printStackTrace();
			fail(ex.getLocalizedMessage());
		}
	}
}
