package net.sqs2.omr.execute.page;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import net.sqs2.exigrid.source.PageTaskException;
import net.sqs2.image.ImageFactory;
import net.sqs2.omr.source.config.ConfigConfigImpl;
import net.sqs2.omr.source.config.SourceConfig;

public class PageFramScannerTest extends TestCase {
	List<BufferedImage> imageList = new ArrayList<BufferedImage>();
	
	@Override
	public void setUp(){
	}
	
	@Override
	public void tearDown(){
	}
	
	
	public void testScanCorners(){
		try{
			testScanCorners("/home/hiroya/Desktop/nagasa/a001.tif",
					new int[][]{{264,102,50,50},
						{1317,96,50,50},
						{279,2163,25,50},
						{1326,2151,25,50}});

			testScanCorners("/home/hiroya/Desktop/nagasa/a003.tif",
					new int[][]{{261,114,50,50},
							{1314,102,50,50},
							{270,2169,25,50},
							{1320,2157,25,50}});
			
		}catch(IOException ex){
			ex.printStackTrace();
			fail(ex.getMessage());
		}catch(PageTaskException ex){
			ex.printStackTrace();
			fail(ex.getMessage());
		}
	}
	
	private void testScanCorners(String path, int[][] corners)throws PageTaskException, IOException{
		BufferedImage image = ImageFactory.createImage(path);
		System.err.println(path);
		ConfigConfigImpl sourceDirectoryConfig = new ConfigConfigImpl();
		SourceConfig sourceConfig = sourceDirectoryConfig.getSourceConfig(path, 1);
		PageFrameScanner scanner = new PageFrameScanner(sourceConfig, image);
		
		Point[] c = scanner.scanPageFrameCorners();
		for(int i=0; i<4; i++){
			int x = corners[i][0];
			int y = corners[i][1];
			int w = corners[i][2];
			int h = corners[i][3];
			boolean result = new Rectangle(x, y, w, h).contains(c[i]);
			System.err.println("\t"+i+":"+x+","+y+","+w+","+h+":\t"+c[i]+"\t"+result);
			assertTrue(result);
		}
		image.flush();
	}
}
