package net.sqs2.omr.execute.page;
import junit.framework.TestCase;
public class ImageSilhouetteExtractTest extends TestCase {
	final static boolean _ = false; 
	final static boolean o = true;
	final static String LABEL = " 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	final static int LABEL_LENGTH = LABEL.length();
	boolean[] src = new boolean[]{
			o,_,_,_,o,_,_,_,_,_, _,_,o,_,_,_,_,o,_,_, _,_,_,_,_,o,_,_,_,_, _,_,o,o,o,o,o,o,o,_, _,o,_,_,_,_,o,o,o,o,
			_,_,_,_,_,o,_,_,_,_, _,o,_,_,_,o,o,o,o,o, _,_,_,_,o,_,_,_,_,_, _,_,_,_,_,_,o,_,o,_, _,o,o,o,o,o,o,o,o,o,
			o,_,_,_,_,_,o,_,_,_, o,_,_,_,_,_,_,o,_,_, _,_,_,o,_,_,_,_,_,_, _,_,_,_,_,_,_,_,_,_, _,_,_,_,_,_,_,_,_,_,
			o,_,_,_,_,_,_,o,_,o, _,_,_,_,_,_,_,_,_,_, _,_,_,_,_,_,o,_,_,_, _,o,o,o,o,o,o,o,o,o, _,_,_,_,o,_,o,_,o,_,
			o,o,o,o,o,o,_,_,o,_, _,_,_,o,o,o,o,o,o,o, _,_,_,_,_,_,_,o,_,_, _,o,_,_,_,_,_,_,_,o, _,_,_,_,_,o,_,o,_,o,
			o,_,_,_,_,_,_,o,_,o, _,_,_,o,_,_,_,_,_,o, _,_,_,_,_,_,_,_,o,_, _,o,_,o,o,o,o,o,_,o, _,_,_,_,o,_,o,_,o,_,
			_,o,_,_,_,_,o,_,_,_, o,_,_,o,_,o,o,o,_,o, _,_,_,_,_,_,o,_,_,_, _,o,_,o,_,_,_,o,_,o, _,_,_,_,_,_,_,_,_,_,
			_,_,o,_,_,o,_,_,o,_, _,o,_,o,_,o,o,o,_,o, _,_,_,_,_,_,_,_,_,_, _,o,_,o,_,o,o,o,_,o, _,_,_,_,o,_,o,_,o,_,
			_,_,_,o,_,_,_,o,_,_, _,_,_,o,_,_,_,_,_,o, _,_,_,o,_,_,_,o,_,_, _,o,_,o,_,_,_,_,_,o, _,_,_,_,_,o,_,o,_,o,
			_,_,_,_,o,o,o,_,_,_, _,_,_,o,o,o,o,o,o,o, _,_,_,_,_,o,_,_,_,_, _,o,_,o,o,o,o,o,o,o, _,_,_,_,o,_,o,_,o,_,
	};

	public void testConst(){
		/*
		boolean[] src0 = new boolean[]{
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o,
				o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o, o,o,o,o,o,o,o,o,o,o
		};*/
		ImageSilhouetteExtract ise = new ImageSilhouetteExtract(src, 50, 10);
		print(ise.getSilhouetteIndexArray(), 50, 10);
		
		//int[] repaintLabelTable = ise.getRepaintLabelTable();
		//printHeader(repaintLabelTable.length);
		//printBody(repaintLabelTable);
		
		int[] areasArray = ise.getAreaArray();
		for(int i = 0; i < areasArray.length; i++){
			if(0<areasArray[i]){
				System.out.println("label "+getLabelChar(i)+" = "+areasArray[i]+" pixel(s)");
			}
		}
	}
	

	void printHeader(int length){
		for(int i = 0; i < length; i++){
			System.out.print(i%10);
		}
		System.out.println();
	}
	
	void printBody(int[] table){
		for(int i = 0; i < table.length; i++){
			System.out.print(table[i]);
		}
		System.out.println();
	}
	
	void print(int[] label, int width, int height){
		for(int y = 0; y < height; y++){
			for(int x = 0; x < width; x++){
				int p = label[x+y*width];
				char c = getLabelChar(p);
				System.out.print(c);
			}
			System.out.println();
		}
	}

	private char getLabelChar(int p) {
	    char c;
	    if(p < LABEL_LENGTH){
	    	c = LABEL.charAt(p);
	    }else{
	    	c = '*';
	    }
	    return c;
    }
}
