package net.sqs2.exigrid.source;

import java.io.File;

import junit.framework.TestCase;
import net.sqs2.exigrid.master.PageMasterFactory;

public class SessionSourceTest extends TestCase {
	
	SessionSource sessionSource = null;
	public void setUp(){
	}
	
	synchronized SessionSource getSessionSource()throws Exception{
		if(sessionSource == null){
		    PageMasterFactory pageMasterFactory = (PageMasterFactory)Class.forName("net.sqs2.omr.master.FormMasterFactory").newInstance();
		    PageTaskConfigFactory pageTaskConfigFactory = (PageTaskConfigFactory)Class.forName("net.sqs2.omr.source.config.PageTaskConfigFactoryImpl").newInstance();
			this.sessionSource = new SessionSource(
				new File("/home/hiroya/Desktop/sqs-sample-images"),
				new File("/home/hiroya/Desktop/sqs-sample-images-RESULT"), 
				pageMasterFactory,
				pageTaskConfigFactory
			);
		}
		return sessionSource;
	}
	
	public void testCreateMasterSet() throws Exception{
		SessionSource sessionSource = getSessionSource();
		sessionSource.scanSourceDirectory(null);//true, 
		assertEquals(sessionSource.getPageMasterSet().size(), 1);
		assertEquals(sessionSource.getPageMaster("sqs.pdf").getPath(), "sqs.pdf");
	}
}
