// ================================================================
//  jkl-resizable.js ---- JavaScript Kantan Library for Resizing
//  Copyright 2005 Kawasaki Yusuke <u-suke@kawa.net>
// ================================================================
//  v0.02  2005/06/16  first release
//  v0.04  2005/06/27  new method: resizeTo() resizeBy()
// ================================================================
//  KNOWN BUG: Opera 8 could not shorten x-width
// ================================================================

if ( typeof(JKL) == 'undefined' ) JKL = function() {};

//  constructor 

JKL.Resizable = function( cont ){
    this.bodyid = cont;         // body area id
    this.__elem = null;         // body area element
    this.sizeX = null;          // body area size
    this.sizeY = null;
    this.curX = null;          // previous clientX
    this.curY = null;
    this.onDrag = false;        // draging=true, released=false
    this.saveEvents = [];       // backup event on dragging
    this.saveCursor = "";       // backup cursor on dragging
    return this;
};

//  class variables

JKL.Resizable.VERSION = "0.04";
JKL.Resizable.SAVE_EVENTS = [ 
    "onmousedown", "onmousemove", 
    "onmouseout", "onmouseover", 
    "onmouseup", "onselect"
];

//  methods

JKL.Resizable.prototype.setEast = function (elemid) { 
    this.setEdge( elemid, true, false, "e-resize" );
};
JKL.Resizable.prototype.setSouth = function (elemid) { 
    this.setEdge( elemid, false, true, "s-resize" );
};
JKL.Resizable.prototype.setSouthEast = function (elemid) { 
    this.setEdge( elemid, true, true, "se-resize" );
};

//  resize (absolute)

JKL.Resizable.prototype.resizeTo = function (x,y) {
    var bodyelem = this.getBodyElement();
    if ( x ) bodyelem.style.width  = x+"px";
    if ( y ) bodyelem.style.height = y+"px";
}

//  resize (relative)

JKL.Resizable.prototype.resizeBy = function (x,y) {
    var bodyelem = this.getBodyElement();
    if ( x ) bodyelem.style.width  = bodyelem.offsetWidth +x+"px";
    if ( y ) bodyelem.style.height = bodyelem.offsetHeight+y+"px";
}

JKL.Resizable.prototype.setEdge = function (elemid,boolX,boolY,cursorS) {
    var bodyelem = this.getBodyElement();
    this.sizeX = bodyelem.offsetWidth;
    this.sizeY = bodyelem.offsetHeight;

    var edgelem;
    if ( typeof(elemid) == "object" && elemid.parentNode ) {
        edgelem = elemid;
    } else { 
        edgelem = document.getElementById( elemid );
    }
    if ( ! edgelem ) return;    // no such element

    edgelem.style.cursor = cursorS;
    var copy = this;
    edgelem.onmousedown = function(ev) {
        copy.dragStart(ev,boolX,boolY,cursorS);
    };
};

JKL.Resizable.prototype.dragStart = function (ev,boolX,boolY,cursorS) {
    if ( this.onDrag ) return;
    this.onDrag = true;                     // start drag mode

    this.backupEvent();                     // backup events and cursor style

    if ( document.all && ! ev ) ev = event;
    this.curX = ev.clientX;                // cursor
    this.curY = ev.clientY;

    document.body.style.cursor = cursorS;   // cursor style

    var copy = this;
    document.onmousemove = function(ev){ copy.dragMove( ev,boolX,boolY ); };
    document.onmouseup   = function(ev){ copy.dragFinish( ev ); };
};

JKL.Resizable.prototype.dragMove = function (ev,boolX,boolY) {
    if ( ! this.onDrag ) return;
    if ( document.all && ! ev ) ev = event;
    var elem = this.getBodyElement();

    var newX = this.sizeX + ev.clientX - this.curX;
    if ( boolX && newX > 0 ) {
        elem.style.width = newX+"px";
        this.sizeX = newX;
        this.curX = ev.clientX;
    }

    var newY = this.sizeY + ev.clientY - this.curY;
    if ( boolY && newY > 0 ) {
        elem.style.height = newY+"px";
        this.sizeY = newY;
        this.curY = ev.clientY;
    }
};

JKL.Resizable.prototype.dragFinish = function (ev) {
    if ( ! this.onDrag ) return;
    this.restoreEvent();
    this.onDrag = false;
};

JKL.Resizable.prototype.backupEvent = function () {
    for ( var i=0; i<JKL.Resizable.SAVE_EVENTS.length; i++ ) {
        var key = JKL.Resizable.SAVE_EVENTS[i];
        this.saveEvents[key] = document[key];
        document[key] = null;
    }
    this.saveCursor = document.body.style.cursor;
};

JKL.Resizable.prototype.restoreEvent = function () {
    for ( var i=0; i<JKL.Resizable.SAVE_EVENTS.length; i++ ) {
        var key = JKL.Resizable.SAVE_EVENTS[i];
        document[key] = this.saveEvents[key];
    }
    this.saveEvents.length = 0;
    document.body.style.cursor = this.saveCursor;
};

JKL.Resizable.prototype.getBodyElement = function () {
    if ( ! this.__elem ) {
        if ( typeof(this.bodyid) == "object" && this.bodyid.parentNode ) {
            this.__elem = this.bodyid;
            this.bodyid = this.__elem.id;
        } else { 
            this.__elem = document.getElementById( this.bodyid );
        }
    }
    return this.__elem;
};

// ================================================================
