/*

 MarkReaderLauncher.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2006/01/10

 */
package net.sqs2.omr.swing;

import java.net.URL;

import net.sqs2.exigrid.engine.ExigridEngine;
import net.sqs2.exigrid.swing.ExigridLauncher;
import net.sqs2.net.ClassURLStreamHandlerFactory;
import net.sqs2.omr.engine.MarkReaderEngineFactory;
import net.sqs2.omr.httpd.SQSHttpdManager;

public class MarkReaderLauncher extends ExigridLauncher {
	static private final long serialVersionUID = 0L;
	protected void exit() throws Exception{
		SQSHttpdManager.getEXIgridHttpd().stop();
		super.exit();
	}

	public static void main(final String[] args)throws Exception{
		final String sourceDirectoryRootPath;
		if(1 <= args.length){
			sourceDirectoryRootPath = args[0]; 
		}else{
			sourceDirectoryRootPath = null;
		}

		// System.err.println("Usage: MarkReaderEngineLauncher <sourceDirectoryRoot> <uploadSiteURI>");

		final int port = 1099;
		try{
			URL.setURLStreamHandlerFactory(new ClassURLStreamHandlerFactory());
		}catch(Error ignore){}

		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try{
					MarkReaderLauncher omrMainFrame = new MarkReaderLauncher();
					omrMainFrame.activate(port);
					
					final ExigridEngine engine = new MarkReaderEngineFactory().create(port);
					omrMainFrame.initialize(engine, sourceDirectoryRootPath);
					omrMainFrame.getFrame().pack();
					omrMainFrame.getFrame().setVisible(true);
				}catch(Exception ignore){
					ignore.printStackTrace();
				}
			}
		});
	}
}
