/*

 PageTaskConfig.java
 
 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2007/01/11

 */
package net.sqs2.omr.source.config;

import java.io.Serializable;

import net.sqs2.exigrid.source.ConfigConfig;
import net.sqs2.exigrid.source.PageTaskConfig;
import net.sqs2.util.FileResource;

public class PageTaskConfigImpl implements Serializable, PageTaskConfig{
	
	private static final long serialVersionUID = 0L;

	private FileResource fileResource;
	ConfigConfig config;
	
	public static final FileResource DEFAULT_SOURCE_CONFIG_URI_WITH_LASTMODIFIED = new FileResource(null, 0L);
	public static PageTaskConfig DEFAULT_INSTANCE = null;
	static{
		DEFAULT_INSTANCE = createDefaultInstance();
	}
	
	public PageTaskConfigImpl(String basePath, String path, long lastModified){
		this.fileResource = new FileResource(path, lastModified);
		this.config = ConfigConfigImpl.createInstance(basePath, path);
	}
	
	public PageTaskConfigImpl(){
		this.fileResource = PageTaskConfigImpl.DEFAULT_SOURCE_CONFIG_URI_WITH_LASTMODIFIED;
		this.config = new ConfigConfigImpl();
	}
	
	public static PageTaskConfig createDefaultInstance(){
		return new PageTaskConfigImpl();
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.exigrid.source.config.PageTaskConfig#getConfig()
	 */
	public ConfigConfig getConfigConfig(){
		return this.config;
		/*
		if(this.config != null){
			
		}else{
			return (SourceDirectoryConfig)DEFAULT_INSTANCE;
		}*/
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.exigrid.source.config.PageTaskConfig#getFileResource()
	 */
	public FileResource getFileResource(){
		return this.fileResource;
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.exigrid.source.config.PageTaskConfig#lastModified()
	 */
	public long lastModified(){
		return this.fileResource.getLastModified();
	}
	
	/* (non-Javadoc)
	 * @see net.sqs2.exigrid.source.config.PageTaskConfig#getPath()
	 */
	public String getPath(){
		return this.fileResource.getPath();
	}
	
	public boolean equals(Object obj){
		if(obj instanceof PageTaskConfigImpl){
			PageTaskConfigImpl o = (PageTaskConfigImpl) obj;
			return this.fileResource.equals(o.fileResource);
		}else{
			return false;
		}
	}

	public int hashCode(){
		return this.fileResource.hashCode();
	}
}
