/**
 *  PageTaskConfigFactory.java
 
 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.source.config;

import net.sqs2.exigrid.source.PageTaskConfig;
import net.sqs2.exigrid.source.PageTaskConfigFactory;

public class PageTaskConfigFactoryImpl implements PageTaskConfigFactory {

	private static PageTaskConfig defaultInstance = new PageTaskConfigImpl();
	
	public PageTaskConfigFactoryImpl(){}
	
	public PageTaskConfig create(String basePath, String path, long lastModified) {
		return new PageTaskConfigImpl(basePath, path, lastModified);
	}
	
	public PageTaskConfig getDefaultInstance(){
		return defaultInstance;
	}

}
