/**
 *  GuideAreaExtractionConfig.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/07
 Author hiroya
 */
package net.sqs2.omr.source.config;

import java.io.Serializable;

public class GuideAreaExtractionConfig implements Serializable{
	private static final long serialVersionUID = 0L;

	double horizontalMarginRatio;
	double verticalMarginRatio;
	double pageGuideAreaHeightRatio;

	public GuideAreaExtractionConfig(){
	}

	public double getHorizontalMarginRatio() {
		return this.horizontalMarginRatio;
	}

	public void setHorizontalMarginRatio(double horizontalMarginRatio) {
		this.horizontalMarginRatio = horizontalMarginRatio;
	}

	public double getPageGuideAreaHeightRatio() {
		return this.pageGuideAreaHeightRatio;
	}

	public void setPageGuideAreaHeightRatio(double verticalGuideAreaRatio) {
		this.pageGuideAreaHeightRatio = verticalGuideAreaRatio;
	}

	public double getVerticalMarginRatio() {
		return this.verticalMarginRatio;
	}

	public void setVerticalMarginRatio(double verticalMarginRatio) {
		this.verticalMarginRatio = verticalMarginRatio;
	}

}