/*

 SourceDirectoryConfig.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on Apr 7, 2007

 */

package net.sqs2.omr.source.config;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import net.sqs2.exigrid.engine.ExigridEngine;
import net.sqs2.exigrid.source.ConfigConfig;
import net.sqs2.exigrid.source.PageTask;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;


public class ConfigConfigImpl implements ConfigConfig, Serializable{
	private final static long serialVersionUID = 0L;
	public final static ConfigConfig DEFAULT_INSTANCE;
	protected static final Digester DIGESTER;

	static{
		try{
			String baseURI = ExigridEngine.getBaseURI();
			DIGESTER = DigesterLoader.createDigester(new URL(baseURI+"sourceDirectoryConfigRule.xml"));
			DEFAULT_INSTANCE = (ConfigConfig)DIGESTER.parse(new URL(baseURI+"sourceDirectoryConfig.xml"));			
		}catch(Exception ex){
			throw new RuntimeException(ex);
		}
	}

	protected List<SourceConfig> sourceList = new ArrayList<SourceConfig>();

	public static ConfigConfigImpl createInstance(String basePath, String path){
		try{
			return (ConfigConfigImpl)DIGESTER.parse(basePath+File.separatorChar+path);
		}catch(IOException ex){
			throw new RuntimeException(ex);
		}catch(SAXException ex){
			throw new RuntimeException(ex);
		}
	}

	ResultConfig result = new ResultConfig();



	public void addSource(SourceConfig sourceConfig){		
		this.sourceList.add(sourceConfig);
	}

	public SourceConfig getSourceConfig(PageTask pageTask){
		return getSourceConfig(pageTask.getPageID().getPath(), pageTask.getPageNumber());
	}

	public SourceConfig getSourceConfig(String path, int pageNumber){
		for(SourceConfig sourceConfig: this.sourceList){
			if(sourceConfig.match(path, pageNumber)){
				return sourceConfig;
			}
		}
		return ((ConfigConfigImpl)DEFAULT_INSTANCE).getSource(0);
	}

	public SourceConfig getSource(int index){
		return this.sourceList.get(index);
	}

	public void setResult(ResultConfig resultConfig){
		this.result = resultConfig;
	}

	public ResultConfig getResult(){
		return this.result;
	}
}
