package net.sqs2.omr.result.module.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import net.sqs2.omr.result.MarkAreaAnswerItem;
import net.sqs2.omr.result.event.MasterEvent;
import net.sqs2.omr.result.event.ProcessErrorEvent;
import net.sqs2.omr.result.event.QuestionEvent;
import net.sqs2.omr.result.event.QuestionItemEvent;
import net.sqs2.omr.result.event.ResultEventImpl;
import net.sqs2.omr.result.event.ResultEventHandler;
import net.sqs2.omr.result.event.RowEvent;
import net.sqs2.omr.result.event.TableEvent;


public class ResultEventDumpEventHandler extends ResultEventHandler {
	
	String encoding;
	XMLStreamWriter writer;
	
	private static final String namespaceURI = "http://sqs-xml.sourceforge.jp/2007/ResultEventDump";
	
	public ResultEventDumpEventHandler(OutputStream outputStream, String encoding)throws IOException{		
		try{
			this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, encoding);
			this.encoding = encoding;
		}catch(XMLStreamException ex){
			throw new IOException(ex);
		}
	}

	public ResultEventDumpEventHandler(File outputFile, String encoding)throws IOException{
		this(new FileOutputStream(outputFile), encoding);
	}
	
	@Override
    public void startResult(ResultEventImpl ev) throws IOException {
	    super.startResult(ev);
	    try{
	    	this.writer.writeStartDocument(encoding, "1.0");
	    	this.writer.setDefaultNamespace(namespaceURI);
	    	this.writer.writeStartElement("result");
	    	this.writer.writeDefaultNamespace(namespaceURI);
	    	this.writer.writeAttribute("sourceDirectoryRoot", ev.getResultEventContext().getSourceDirectoryRoot().getAbsolutePath());
	    	this.writer.writeAttribute("resultDirectoryRoot", ev.getResultPathFactory().getResultDirectoryRoot().getAbsolutePath());
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
    }

	/**
	 * at the end of this method execution, close the XMLStreamWriter object.
	 */
	@Override
    public void endResult(ResultEventImpl ev) throws IOException {
	    try{
	    	this.writer.writeEndElement();	
	    	this.writer.writeEndDocument();
	    	this.writer.close();
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
	    super.endResult(ev);
    }
	
	@Override
    public void startMaster(MasterEvent ev) throws IOException {
	    super.startMaster(ev);
	    try{
	    	this.writer.writeStartElement("master");
	    	this.writer.writeAttribute("masterIndex", String.valueOf(ev.getMasterIndex()));
	    	this.writer.writeAttribute("masterPath", ev.getFormMaster().getPath());
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
    }
	
	@Override
    public void endMaster(MasterEvent ev) throws IOException {
		 try{
			 this.writer.writeEndElement();	
		 }catch(XMLStreamException ex){
			 ex.printStackTrace();
		 }
	    super.endMaster(ev);
    }

	@Override
    public void startTable(TableEvent ev) throws IOException {
	    try{
	    	this.writer.writeStartElement("table");
	    	this.writer.writeAttribute("tableIndex", String.valueOf(ev.getTableIndex()));
	    	this.writer.writeAttribute("isLeaf", String.valueOf(ev.isLeaf()));
	    	this.writer.writeAttribute("sourceDirectoryPath", ev.getSourceDirectory().getPath());
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
	    super.startTable(ev);
    }
	
	@Override
    public void endTable(TableEvent ev) throws IOException {
		 try{
			 this.writer.writeEndElement();	
		 }catch(XMLStreamException ex){
			 ex.printStackTrace();
		 }
	    super.endTable(ev);
    }

	@Override
    public void startRow(RowEvent ev) throws IOException {
	    try{
	    	this.writer.writeStartElement("row");
	    	this.writer.writeAttribute("rowIndex", String.valueOf(ev.getRowIndex()));
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
	    super.startRow(ev);
    }

	@Override
    public void endRow(RowEvent ev) throws IOException {
		 try{
			 this.writer.writeEndElement();
			 this.writer.flush();
		 }catch(XMLStreamException ex){
			 ex.printStackTrace();
		 }
	    super.endRow(ev);
    }

	@Override
    public void startQuestion(QuestionEvent ev) throws IOException {
	    try{
	    	this.writer.writeStartElement("question");
	    	this.writer.writeAttribute("columnIndex", String.valueOf(ev.getColumnIndex()));
	    	this.writer.writeAttribute("qid", String.valueOf(ev.getQID()));
	    	this.writer.writeAttribute("type", ev.getDefaultFormArea().getType());
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
	    super.startQuestion(ev);
    }

	@Override
    public void endQuestion(QuestionEvent ev) throws IOException {
		 try{
			 this.writer.writeEndElement();	
		 }catch(XMLStreamException ex){
			 ex.printStackTrace();
		 }
	    super.endQuestion(ev);
    }

	@Override
    public void startQuestionItem(QuestionItemEvent ev) throws IOException {
	    try{
	    	this.writer.writeStartElement("questionItem");
	    	this.writer.writeAttribute("page", String.valueOf(ev.getFormArea().getPage()));
	    	if(ev.getDefaultFormArea().isMarkArea()){
	    		MarkAreaAnswerItem maa = ev.getMarkAreaAnswerItem();
	    		this.writer.writeAttribute("itemIndex", String.valueOf(maa.getItemIndex()));
	    		this.writer.writeAttribute("density", String.valueOf(maa.getDensity()));
	       		this.writer.writeAttribute("isMarked", Boolean.toString(maa.isMarked()));
	       		this.writer.writeAttribute("isAutoSelected", Boolean.toString(maa.isAutoSelected()));
	       		this.writer.writeAttribute("isSelected", Boolean.toString(maa.isSelected()));
	    	}
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
	    super.startQuestionItem(ev);
    }

	@Override
    public void endQuestionItem(QuestionItemEvent ev) throws IOException {
		 try{
			 this.writer.writeEndElement();	
		 }catch(XMLStreamException ex){
			 ex.printStackTrace();
		 }
	    super.endQuestionItem(ev);
    }

	@Override
    public void startError(ProcessErrorEvent ev) throws IOException {
	    try{
	    	this.writer.writeStartElement("error");	
	    }catch(XMLStreamException ex){
	    	ex.printStackTrace();
	    }
	    super.startError(ev);
    }

	@Override
    public void endError(ProcessErrorEvent ev) throws IOException {
		 try{
			 this.writer.writeEndElement();	
		 }catch(XMLStreamException ex){
			 ex.printStackTrace();
		 }
	    super.endError(ev);
    }
}
