package net.sqs2.omr.result.module.core;

import java.io.IOException;

import net.sqs2.exigrid.source.PageTask;
import net.sqs2.exigrid.source.PageTaskError;
import net.sqs2.omr.result.ResultPathFactory;
import net.sqs2.util.DateFormatUtil;

public class PlainTextErrorLogEventHandler extends AbstractErrorLogHandler {
	
	public PlainTextErrorLogEventHandler(ResultPathFactory resultPathFactory) throws IOException {
		super(resultPathFactory, "txt", "UTF-8");
	}

	public void log(PageTask pageTask, PageTaskError pageTaskError, String uri) {
		this.writer.print("");
		// this.writer.print(imagePathBuilder.toString());
		// this.writer.print("\t");
		this.writer.print(DateFormatUtil.format());
		this.writer.print('\t');
		this.writer.print(uri);
		if (1 < pageTask.getPageID().getNumPagesInFile()) {
			this.writer.print('(');
			this.writer.print(pageTask.getPageID().getIndex());
			this.writer.print(')');
		}
		this.writer.print('\t');
		this.writer.print(pageTaskError.getExceptionCore().getLocalizedMessage());
		this.writer.println();
		this.writer.flush();
	}
}
